package org.bidib.wizard.mvc.main.controller;

import javax.swing.SwingUtilities;

import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.main.model.FeedbackPositionModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.FeedbackPositionListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPositionPanelController {

    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionPanelController.class);

    private final MainModel mainModel;

    private final WizardSettingsInterface wizardSettings;

    private final NodeListListener nodeListListener;

    private final FeedbackPositionModel feedbackPositionModel;

    private FeedbackPositionListPanel feedbackPositionListPanel;

    public FeedbackPositionPanelController(final MainModel mainModel, final WizardSettingsInterface wizardSettings) {
        this.mainModel = mainModel;
        this.wizardSettings = wizardSettings;

        feedbackPositionModel = new FeedbackPositionModel(this.wizardSettings);

        nodeListListener = new DefaultNodeListListener() {
            @Override
            public void nodeChanged(final NodeInterface node) {
                final NodeInterface selectedNode = mainModel.getSelectedNode();
                LOGGER.info("The node has changed, selectedNode: {}", selectedNode);

                // update the selected node
                feedbackPositionModel.setSelectedNode(selectedNode);

                SwingUtilities.invokeLater(() -> {
                    LOGGER.info("Notify that the selected node was changed.");
                    if (feedbackPositionListPanel != null) {
                        feedbackPositionListPanel.listChanged();
                    }
                    else {
                        LOGGER.warn("The feedbackPortListPanel is not available.");
                    }
                });
            }
        };
        this.mainModel.addNodeListListener(nodeListListener);

    }

    public NodeInterface getSelectedNode() {
        return feedbackPositionModel.getSelectedNode();
    }

    public FeedbackPositionListPanel createFeedbackPositionListPanel(
        final TabVisibilityListener tabVisibilityListener) {
        LOGGER.info("Create new feedbackPositionListPanel.");
        feedbackPositionListPanel =
            new FeedbackPositionListPanel(this, feedbackPositionModel, mainModel, tabVisibilityListener);

        return feedbackPositionListPanel;
    }

}
