package org.bidib.wizard.mvc.main.controller.listener;

import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.wizard.api.model.Macro;

public interface MacroPanelListener {

    /**
     * Store the macro on the node.
     * 
     * @param macro
     *            the macro
     */
    void storeMacroOnNode(Macro macro);

    /**
     * Load the macro with the specified macro id from the node.
     * 
     * @param macro
     *            the macro
     * @return the macro state
     */
    LcMacroState reloadMacro(Macro macro);

    /**
     * Store the macro with the specified macro id on the node.
     * 
     * @param macro
     *            the macro
     * @return the macro state
     */
    LcMacroState saveMacro(Macro macro);

    /**
     * Start the macro with the specified macro id on the node.
     * 
     * @param macro
     *            the macro
     * @param transferBeforeStart
     *            transfer the macro before start
     * @return the macro state
     */
    LcMacroState startMacro(Macro macro, boolean transferBeforeStart);

    /**
     * Stop the macro with the specified macro id on the node.
     * 
     * @param macro
     *            the macro
     * @return the macro state
     */
    LcMacroState stopMacro(Macro macro);

    /**
     * Transfer the macro to the node but don't store in permanent memory.
     * 
     * @param macro
     *            the macro
     */
    void transferMacro(Macro macro);
}
