package org.bidib.wizard.mvc.main.model;

import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.AccessoryAspect;
import org.bidib.wizard.api.model.AccessoryAspectMacro;
import org.bidib.wizard.api.model.AccessoryAspectParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;

public class AccessoryStartupAspectModel extends Model {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryStartupAspectModel.class);

    public static final String PROPERTY_SELECTED_STARTUP_ASPECT = "selectedStartupAspect";

    private static final int STARTUP_ASPECT_INDEX_INVALID = 0;

    private static final int STARTUP_ASPECT_INDEX_UNCHANGED = 1;

    private static final int STARTUP_ASPECT_INDEX_RESTORE = 2;

    private AccessoryAspect selectedStartupAspect;

    private ArrayListModel<AccessoryAspect> accessoryAspectList = new ArrayListModel<>();

    public ArrayListModel<AccessoryAspect> getAccessoryAspectList() {
        return accessoryAspectList;
    }

    public void clearAccessoryAspects() {
        accessoryAspectList.clear();

        // add the default values
        AccessoryAspectParam unknown =
            new AccessoryAspectParam(-1, Resources.getString(getClass(), "aspectParam-unknown") + " ");
        unknown.setInvalid(true);
        accessoryAspectList.add(STARTUP_ASPECT_INDEX_INVALID, unknown);
        accessoryAspectList
            .add(STARTUP_ASPECT_INDEX_UNCHANGED, new AccessoryAspectParam(BidibLibrary.ASPECT_PARAM_UNCHANGED,
                Resources.getString(getClass(), "aspectParam-unchanged")));
        accessoryAspectList
            .add(STARTUP_ASPECT_INDEX_RESTORE, new AccessoryAspectParam(BidibLibrary.ASPECT_PARAM_RESTORE,
                Resources.getString(getClass(), "aspectParam-restore")));
    }

    public void addAccessoryAspect(AccessoryAspect accessoryAspect) {
        accessoryAspectList.add(accessoryAspect);
    }

    public void setSelectedStartupAspect(AccessoryAspect selectedStartupAspect) {
        LOGGER.info("Set the selected startup aspect: {}", selectedStartupAspect);

        AccessoryAspect oldValue = this.selectedStartupAspect;
        this.selectedStartupAspect = selectedStartupAspect;

        firePropertyChange(PROPERTY_SELECTED_STARTUP_ASPECT, oldValue, selectedStartupAspect);
    }

    public AccessoryAspect getSelectedStartupAspect() {
        return selectedStartupAspect;
    }

    public AccessoryAspect getAssignedAspect(final int value, int aspectCount) {
        LOGGER.info("Get the assigned aspect, value: {}, aspectCount: {}", value, aspectCount);
        
        AccessoryAspect accessoryAspect = null;
        switch (value) {
            case BidibLibrary.ASPECT_PARAM_UNCHANGED:
                accessoryAspect = accessoryAspectList.get(STARTUP_ASPECT_INDEX_UNCHANGED);
                break;
            case BidibLibrary.ASPECT_PARAM_RESTORE:
                accessoryAspect = accessoryAspectList.get(STARTUP_ASPECT_INDEX_RESTORE);
                break;
            default:
                // check if a valid aspect is assigned
                if (value >= aspectCount) {
                    LOGGER.error("An invalid aspect is assigned, aspectId: {}, aspectCount: {}", value, aspectCount);
                    // throw new IllegalArgumentException("An invalid aspect is assigned: " + value);
                }
                else {
                    // lookup the macro aspects
                    accessoryAspect = IterableUtils.find(accessoryAspectList, new Predicate<AccessoryAspect>() {

                        @Override
                        public boolean evaluate(AccessoryAspect aspect) {

                            if (aspect instanceof AccessoryAspectMacro) {
                                AccessoryAspectMacro aspectMacro = (AccessoryAspectMacro) aspect;
                                if (aspectMacro.getMacroRef() != null && value == aspectMacro.getIndex()) {

                                    return true;
                                }
                                else if (aspectMacro.isImmutableAccessory() && aspectMacro.getIndex() == value) {
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                }
                if (accessoryAspect == null) {
                    LOGGER.warn("No matching accessoryAspect found. Use the first in the list as default value.");

                    // we have a value but no matching aspect -> return 'unknown' aspect
                    accessoryAspect = accessoryAspectList.get(0);
                }
                break;
        }

        return accessoryAspect;
    }
}
