package org.bidib.wizard.mvc.main.model;

import org.bidib.api.json.types.ConnectionPhase;

import com.jgoodies.binding.beans.Model;

/**
 * This model keeps the connection phase of the connection that is active in the main controller.
 */
public class ConnectionPhaseModel extends Model {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CONNECTIONID = "connectionId";

    public static final String PROPERTY_CONNECTIONPHASE = "connectionPhase";

    private String connectionId;

    private ConnectionPhase connectionPhase;

    /**
     * @return the connectionId
     */
    public String getConnectionId() {
        return connectionId;
    }

    /**
     * @param connectionId
     *            the connectionId to set
     */
    public void setConnectionId(String connectionId) {
        String oldValue = this.connectionId;
        this.connectionId = connectionId;
        firePropertyChange(PROPERTY_CONNECTIONID, oldValue, connectionId);
    }

    /**
     * @return the connectionPhase
     */
    public ConnectionPhase getConnectionPhase() {
        return connectionPhase;
    }

    /**
     * @param connectionPhase
     *            the connectionPhase to set
     */
    public void setConnectionPhase(ConnectionPhase connectionPhase) {
        ConnectionPhase oldValue = this.connectionPhase;
        this.connectionPhase = connectionPhase;
        firePropertyChange(PROPERTY_CONNECTIONPHASE, oldValue, connectionPhase);
    }
}
