package org.bidib.wizard.mvc.main.view.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;

import javax.swing.JMenuItem;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.mvc.main.view.menu.listener.AccessoryListMenuListener;

public class AccessoryListMenu extends BasicPopupMenu {
    private static final long serialVersionUID = 1L;

    private final Collection<AccessoryListMenuListener> menuListeners = new LinkedList<AccessoryListMenuListener>();

    private final JMenuItem editLabel;

    private final JMenuItem importAccessory;

    private final JMenuItem exportAccessory;

    private final JMenuItem delete;

    private final JMenuItem save;

    private final JMenuItem reload;

    public AccessoryListMenu() {
        editLabel = new JMenuItem(Resources.getString(getClass(), "editLabel") + " ...");

        editLabel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireEditLabel();
            }
        });
        add(editLabel);

        addSeparator();

        importAccessory = new JMenuItem(Resources.getString(getClass(), "import") + " ...");

        importAccessory.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireImport();
            }
        });
        add(importAccessory);

        exportAccessory = new JMenuItem(Resources.getString(getClass(), "export") + " ...");

        exportAccessory.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireExport();
            }
        });
        add(exportAccessory);

        addSeparator();

        delete = new JMenuItem(Resources.getString(getClass(), "delete"));

        delete.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireDelete();
            }
        });
        delete.setToolTipText(Resources.getString(getClass(), "delete.tooltip"));
        add(delete);

        save = new JMenuItem(Resources.getString(getClass(), "save"));

        save.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireSave();
            }
        });
        save.setToolTipText(Resources.getString(getClass(), "save.tooltip"));
        add(save);

        reload = new JMenuItem(Resources.getString(getClass(), "reload"));

        reload.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireReload();
            }
        });
        reload.setToolTipText(Resources.getString(getClass(), "reload.tooltip"));
        add(reload);
    }

    public void addMenuListener(AccessoryListMenuListener l) {
        menuListeners.add(l);
    }

    private void fireEditLabel() {
        for (AccessoryListMenuListener l : menuListeners) {
            l.editLabel(null);
        }
    }

    private void fireExport() {
        for (AccessoryListMenuListener l : menuListeners) {
            l.exportAccessory();
        }
    }

    private void fireImport() {
        for (AccessoryListMenuListener l : menuListeners) {
            l.importAccessory();
        }
    }

    private void fireDelete() {
        for (AccessoryListMenuListener l : menuListeners) {
            l.deleteAccessory();
        }
    }

    private void fireSave() {
        for (AccessoryListMenuListener l : menuListeners) {
            l.saveAccessory();
        }
    }

    private void fireReload() {
        for (AccessoryListMenuListener l : menuListeners) {
            l.reloadAccessory();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        editLabel.setEnabled(enabled);
        importAccessory.setEnabled(enabled);
        exportAccessory.setEnabled(enabled);
        delete.setEnabled(enabled);
        save.setEnabled(enabled);
        reload.setEnabled(enabled);
    }
}
