package org.bidib.wizard.mvc.main.view.panel;

import java.awt.Component;

import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.AccessoryAspectMacro;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractStatusEmptyTable;
import org.bidib.wizard.client.common.view.renderer.MacroRefRenderer;
import org.bidib.wizard.client.common.view.renderer.MacroRenderer;
import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.model.status.AccessoryAspectStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.AccessoryTableModel;
import org.bidib.wizard.mvc.main.view.table.ComboBoxEditor;
import org.bidib.wizard.mvc.main.view.table.ComboBoxRenderer;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonEditor;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.grid.CellStyle;

public class AspectTable extends AbstractStatusEmptyTable {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(AspectTable.class);

    private final NodeSelectionProvider nodeSelectionProvider;

    private final AccessoryTableModel tableModel;

    public AspectTable(final AccessoryTableModel tableModel, String emptyTableString,
        final NodeSelectionProvider mainModel) {
        super(tableModel, emptyTableString);
        this.tableModel = tableModel;
        this.nodeSelectionProvider = mainModel;
    }

    @Override
    public void adjustRowHeight() {
        // set the correct row height
        SliderRenderer sliderEditor = new SliderRenderer(0, 255, 10);

        int rowHeight =
            sliderEditor.getTableCellRendererComponent(this, 1, false, false, 0, 0).getPreferredSize().height + 6;
        LOGGER.info("Set row height: {}", rowHeight);

        setRowHeight(rowHeight);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor result = super.getCellEditor(row, column);

        switch (column) {
            case AccessoryTableModel.COLUMN_MACRO_REF:
                final NodeInterface node = nodeSelectionProvider.getSelectedNode();
                Macro[] macros = node.getMacros().toArray(new Macro[0]);
                MacroRef[] macroRefs = new MacroRef[macros.length];
                int index = 0;
                for (Macro macro : macros) {
                    macroRefs[index] = new MacroRef(macro.getId());
                    index++;
                }
                JComboBox<MacroRef> comboboxMacroRef = new JComboBox<>(macroRefs);
                comboboxMacroRef.setRenderer(new MacroRefRenderer(macros));
                result = new ComboBoxEditor<MacroRef>(comboboxMacroRef) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Component getTableCellEditorComponent(
                        JTable table, Object value, boolean isSelected, int row, int column) {

                        Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                        if (value instanceof MacroRef) {
                            MacroRef macroRef = (MacroRef) value;
                            JComboBox<MacroRef> combo = ((JComboBox<MacroRef>) editorComponent);
                            for (int index = 0; index < combo.getItemCount(); index++) {

                                MacroRef macro = combo.getItemAt(index);
                                if (macro.getId() == macroRef.getId()) {
                                    combo.setSelectedItem(macro);
                                    break;
                                }
                            }
                        }
                        else {
                            LOGGER.debug("Current value is not a MacroRef: {}", value);
                        }

                        return comp;
                    };
                };
                LOGGER.info("Prepared the MacroRef editor.");
                break;
            case AccessoryTableModel.COLUMN_ACCESSORY_ASPECT_INSTANCE:
                ComboBoxWithButtonEditor editor =
                    new ComboBoxWithButtonEditor(getActions(AccessoryAspectStatus.START), ">");

                editor.addButtonListener(tableModel);
                result = editor;
                break;
            default:
                break;
        }
        return result;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer result = null;

        switch (column) {
            case AccessoryTableModel.COLUMN_LABEL:
                // use special renderer for label
                result = new AccessoryLabelRenderer();
                break;
            case AccessoryTableModel.COLUMN_MACRO_REF:
                NodeInterface node = nodeSelectionProvider.getSelectedNode();
                ComboBoxRenderer<Macro> macroRenderer =
                    new ComboBoxRenderer<Macro>(node.getMacros().toArray(new Macro[0])) {
                        private static final long serialVersionUID = 1L;

                        @Override
                        public Component getTableCellRendererComponent(
                            JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            Component comp =
                                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

                            if (value instanceof MacroRef) {
                                MacroRef macroRef = (MacroRef) value;
                                for (int index = 0; index < getItemCount(); index++) {

                                    Macro macro = getItemAt(index);
                                    if (macro.getId() == macroRef.getId()) {
                                        setSelectedItem(macro);
                                        break;
                                    }
                                }
                            }
                            else {
                                LOGGER.debug("Current value is not a MacroRef: {}", value);
                            }

                            comp.setEnabled(true);
                            Object val = table.getModel().getValueAt(row, 2 /* accessory */);
                            if (val instanceof AccessoryAspectMacro) {
                                AccessoryAspectMacro accessory = (AccessoryAspectMacro) val;
                                comp.setEnabled(!accessory.isImmutableAccessory());
                            }

                            return comp;
                        };
                    };
                macroRenderer.setRenderer(new MacroRenderer());
                result = macroRenderer;
                break;
            case AccessoryTableModel.COLUMN_ACCESSORY_ASPECT_INSTANCE:
                result = new ComboBoxWithButtonRenderer<BidibStatus>(getActions(AccessoryAspectStatus.START), ">");
                break;
            default:
                result = super.getCellRenderer(row, column);
                break;
        }
        return result;
    }

    private final static class AccessoryLabelRenderer extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(
            JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                String textValue = Resources.getString(AccessoryTableModel.class, "aspect") + "_" + row;
                LOGGER.debug("Set the default value: {}", textValue);
                setText(textValue);
            }

            return comp;
        }
    }

    @Override
    protected void customizeEditorComponent(int row, int column, Component paramComponent, CellStyle cellStyle) {

        super.customizeEditorComponent(row, column, paramComponent, cellStyle);

        // must handle the label column explicit here because otherwise the text color is not correct
        if (column == AccessoryTableModel.COLUMN_LABEL) {
            paramComponent.setForeground(cellStyle.getForeground());
            return;
        }
    }

}
