package org.bidib.wizard.mvc.main.view.panel.glazed;

import org.bidib.jbidibc.messages.FeedbackPosition;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;

import ca.odell.glazedlists.gui.TableFormat;

public class FeedbackPositionTableFormat implements TableFormat<FeedbackPosition> {

    public static final int COLUMN_LASTSEEN = 4;

    private final String[] columnNames =
        { Resources.getString(FeedbackPositionTableFormat.class, "column.decoder"),
            Resources.getString(FeedbackPositionTableFormat.class, "column.location"),
            Resources.getString(FeedbackPositionTableFormat.class, "column.locationType"),
            Resources.getString(FeedbackPositionTableFormat.class, "column.extendedData"),
            Resources.getString(FeedbackPositionTableFormat.class, "column.lastseen") };

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int column) {

        switch (column) {
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
                return columnNames[column];
            default:
                throw new IllegalStateException();
        }
    }

    @Override
    public Object getColumnValue(FeedbackPosition feedbackPosition, int column) {

        switch (column) {
            case 0:
                return feedbackPosition.getDecoderAddress();
            case 1:
                return feedbackPosition.getLocationId();
            case 2:
                return feedbackPosition.getLocationType();
            case 3:
                return ByteUtils.bytesToHex(feedbackPosition.getExtendedData());
            case 4:
                return feedbackPosition.getLastSeenTimestamp();
            default:
                throw new IllegalStateException();
        }
    }
}
