package org.bidib.wizard.mvc.main.view.statusbar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.UIManager;

import org.bidib.wizard.client.common.led.LED;
import org.bidib.wizard.client.common.uils.SwingUtils;

import com.jidesoft.status.StatusBarItem;

public class ConnectionProviderStatusBarItem extends StatusBarItem {

    private static final long serialVersionUID = 1L;

    private final LED mdnsLed;

    private final JLabel label;

    public ConnectionProviderStatusBarItem() {
        setLayout(new BorderLayout(3, 0));

        Color colorOn = UIManager.getColor("ConnectionProviderStatusBarItem.led_on");
        Color colorOff = UIManager.getColor("ConnectionProviderStatusBarItem.led_off");

        if (colorOn == null) {
            colorOn = Color.blue;
        }
        if (colorOff == null) {
            colorOff = Color.gray;
        }

        this.mdnsLed = new LED(colorOn, colorOff, 1000);
        this.mdnsLed.setName("mDNS");
        this.mdnsLed.setPreferredSize(new Dimension(5, 10));

        this.label = new JLabel();

        add(this.mdnsLed, BorderLayout.WEST);
        add(this.label, BorderLayout.CENTER);
    }

    public void setText(String text) {

        this.label.setText(text);
    }

    @Override
    public void setToolTipText(String tooltipText) {
        this.label.setToolTipText(tooltipText);
    }

    @Override
    public String getItemName() {
        return "ConnectionProviderStatusBarItem";
    }

    public void setDiscoveryEnabled(final boolean discoveryEnabled) {

        SwingUtils.executeInEDT(() -> setLedState(discoveryEnabled));
    }

    private void setLedState(final boolean discoveryEnabled) {
        if (discoveryEnabled) {
            mdnsLed.usePrimary();
        }
        else {
            mdnsLed.useSecondary();
        }
    }
}
