package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AccessoryAspectRenderer extends DefaultTableCellRenderer {

    private static final long serialVersionUID = 1L;

    private final String defaultPrefix;

    public AccessoryAspectRenderer(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
    }

    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        String text = null;
        if (value != null) {
            text = String.format("%1$02d : %2$s", row, value.toString());
        }
        else {
            text = String.format("%1$02d : %2$s%3s02d", row, defaultPrefix, row);
            // setText(defaultPrefix + row);
        }
        setText(text);

        return this;
    }
}
