package org.bidib.wizard.mvc.main.view.table;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;

public class ComboBoxEditor<E> extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;

    public ComboBoxEditor(E[] items) {
        this(new JComboBox<E>(items));
    }

    public static <E extends BidibStatus> ComboBoxEditor<E> createComboBoxEditor(E[] items, String resourceClazz) {
        JComboBox<E> comboBox = new JComboBox<E>(items);
        comboBox.setRenderer(new BidibStatusListRenderer<>(resourceClazz));
        return new ComboBoxEditor<>(comboBox);
    }

    public ComboBoxEditor(final JComboBox<E> comboBox) {
        super(comboBox);
    }
}
