package org.bidib.wizard.mvc.main.view.table;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.model.status.BidibStatus;

public class ComboBoxRenderer<E> extends JComboBox<E> implements TableCellRenderer {
    private static final long serialVersionUID = 1L;

    private Color unselectedForeground;

    private Color unselectedBackground;

    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    public ComboBoxRenderer(E[] items) {
        super(items);

        setOpaque(false);
        setBorder(getNoFocusBorder());
    }

    public static <E extends BidibStatus> ComboBoxRenderer<E> createComboBoxRenderer(E[] items, String resourceClazz) {
        ComboBoxRenderer<E> comboBoxRenderer = new ComboBoxRenderer<E>(items);
        comboBoxRenderer.setRenderer(new BidibStatusListRenderer<>(resourceClazz));
        return comboBoxRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

        Color fg = null;
        Color bg = null;

        if (isSelected) {
            super.setForeground(fg == null ? table.getSelectionForeground() : fg);
            super.setBackground(bg == null ? table.getSelectionBackground() : bg);
        }
        else {
            Color background = unselectedBackground != null ? unselectedBackground : table.getBackground();
            if (background == null || background instanceof javax.swing.plaf.UIResource) {
                Color alternateColor = UIManager.getDefaults().getColor("Table.alternateRowColor");
                if (alternateColor != null && row % 2 != 0) {
                    background = alternateColor;
                }
            }
            super.setForeground(unselectedForeground != null ? unselectedForeground : table.getForeground());
            super.setBackground(background);
        }

        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getDefaults().getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getDefaults().getBorder("Table.focusCellHighlightBorder");
            }
            setBorder(border);

            if (!isSelected && table.isCellEditable(row, column)) {
                Color col;
                col = UIManager.getDefaults().getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                col = UIManager.getDefaults().getColor("Table.focusCellBackground");
                if (col != null) {
                    super.setBackground(col);
                }
            }
        }
        else {
            setBorder(getNoFocusBorder());
        }

        // if (isSelected) {
        // // use table.foreground because under windows the foreground color is white and background is lightgray
        // setForeground(hasFocus ? table.getForeground().brighter() : table.getForeground());
        // setBackground(hasFocus ? table.getSelectionBackground().brighter() : table.getSelectionBackground());
        // Color borderColor =
        // hasFocus ? table.getSelectionBackground()/* .brighter() */ : table.getSelectionBackground();
        // setBorder(BorderFactory.createLineBorder(borderColor));
        // }
        // else {
        // setForeground(table.getForeground());
        // setBackground(table.getBackground());
        // setBorder(null);
        // }
        setSelectedItem(value);
        return this;
    }

    private Border getNoFocusBorder() {
        Border border = UIManager.getDefaults().getBorder("Table.cellNoFocusBorder");
        if (border != null)
            return border;
        return SAFE_NO_FOCUS_BORDER;
    }

    /**
     * Overrides <code>JComponent.setForeground</code> to assign the unselected-foreground color to the specified color.
     *
     * @param c
     *            set the foreground color to this value
     */
    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        unselectedForeground = c;
    }

    /**
     * Overrides <code>JComponent.setBackground</code> to assign the unselected-background color to the specified color.
     *
     * @param c
     *            set the background color to this value
     */
    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        unselectedBackground = c;
    }

    /**
     * Notification from the <code>UIManager</code> that the look and feel [L&amp;F] has changed. Replaces the current
     * UI object with the latest version from the <code>UIManager</code>.
     *
     * @see JComponent#updateUI
     */
    @Override
    public void updateUI() {
        super.updateUI();
        setForeground(null);
        setBackground(null);
    }
}
