package org.bidib.wizard.mvc.main.view.table;

import java.awt.Color;

import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.BidibStatusTableRenderer;
import org.bidib.wizard.client.common.view.renderer.DmxChannelRenderer;
import org.bidib.wizard.client.common.view.renderer.LocalPortConfigErrorAwareRenderer;
import org.bidib.wizard.client.common.view.renderer.PortAwareNumberRenderer;
import org.bidib.wizard.client.common.view.slider.ConfigXAwareSliderRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.mvc.common.view.table.ColorRenderer;
import org.bidib.wizard.mvc.main.model.LightPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.renderer.MappablePortTableCellRenderer;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.TableColumnChooser;

import io.reactivex.rxjava3.subjects.Subject;

public class LightPortTable extends AbstractPortHierarchicalTable<LightPort> {
    private static final long serialVersionUID = 1L;

    private final LightPortTableModel lightPortTableModel;

    public LightPortTable(final LightPortTableModel lightPortTableModel, String emptyTableText) {
        super(lightPortTableModel, emptyTableText);

        this.lightPortTableModel = lightPortTableModel;
    }

    @Override
    protected LightPortEditorPanel createPortEditorPanel(
        final LightPort port, int row, final Subject<PortConfigChangeEvent> portConfigChangeEventSubject,
        final NodeSelectionProvider nodeSelectionProvider) {
        LightPortEditorPanel editorPanel =
            new LightPortEditorPanel(port, lightPort -> this.lightPortTableModel.updatePortConfig(lightPort),
                lightPort -> this.lightPortTableModel.fireTestButtonPressed(lightPort),
                lightPort -> this.lightPortTableModel
                    .refreshRow(lightPort,
                        changedRow -> repaint(getCellRect(changedRow, LightPortTableModel.COLUMN_LABEL, true))),
                portConfigChangeEventSubject, nodeSelectionProvider);
        editorPanel.createComponent();

        return editorPanel;
    }

    @Override
    public void clearTable() {

    }

    @Override
    protected RowStripeTableStyleProvider createTableStyleProvider(final TableModel portTableModel) {
        final RowStripeTableStyleProvider tableStyleProvider =
            new RowStripeTableStyleProvider(UIManager.getColor("tableRowStripe.background"),
                UIManager.getColor("tableRowStripe.alternativeBackground")) {

                @Override
                public CellStyle getCellStyleAt(JTable table, int rowIndex, int columnIndex) {

                    if (columnIndex == LightPortTableModel.COLUMN_RGB) {

                        Color rgbValue = (Color) portTableModel.getValueAt(rowIndex, columnIndex);

                        Port<?> port =
                            (Port<?>) portTableModel.getValueAt(rowIndex, LightPortTableModel.COLUMN_PORT_INSTANCE);
                        CellStyle style = super.getCellStyleAt(table, rowIndex, columnIndex);
                        if (!port.isEnabled() || rgbValue == null) {
                            style = new CellStyle(style);
                            style.setForeground(disabledForeground);
                            return style;
                        }
                        style = new CellStyle(style);
                        style.setBackground(rgbValue);
                        style.setForeground(rgbValue);
                        return style;
                    }
                    else if (columnIndex != LightPortTableModel.COLUMN_LABEL) {
                        return super.getCellStyleAt(table, rowIndex, columnIndex);
                    }
                    else {

                        Port<?> port = (Port<?>) portTableModel.getValueAt(rowIndex, columnIndex);
                        CellStyle style = super.getCellStyleAt(table, rowIndex, columnIndex);
                        if (!port.isEnabled()) {
                            style = new CellStyle(style);
                            style.setForeground(disabledForeground);
                            return style;
                        }
                        return style;

                    }
                }
            };
        return tableStyleProvider;
    }

    @Override
    protected boolean isInsertPortsVisible() {
        // light ports supports insert ports
        return true;
    }

    @Override
    protected boolean isRemovePortVisible() {
        return true;
    }

    @Override
    public void prepareTableColumns() {

        TableColumn tc = getColumnModel().getColumn(LightPortTableModel.COLUMN_LABEL);
        tc.setCellRenderer(new LocalPortConfigErrorAwareRenderer(LightPortTableModel.COLUMN_LABEL));
        tc.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_LABEL));

        // set the PWM sliders
        tc = getColumnModel().getColumn(LightPortTableModel.COLUMN_PWM_MIN);
        tc.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_PWM_MIN));
        tc.setCellRenderer(new ConfigXAwareSliderRenderer(0, 255, 10, BidibLibrary.BIDIB_PCFG_LEVEL_PORT_OFF));

        tc = getColumnModel().getColumn(LightPortTableModel.COLUMN_PWM_MAX);
        tc.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_PWM_MAX));
        tc.setCellRenderer(new ConfigXAwareSliderRenderer(0, 255, 10, BidibLibrary.BIDIB_PCFG_LEVEL_PORT_ON));

        // dimm columns
        tc = getColumnModel().getColumn(LightPortTableModel.COLUMN_DIM_MIN);
        tc.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_DIM_MIN));

        ConfigXAwareSliderRenderer sliderRendererDimmMin =
            new ConfigXAwareSliderRenderer(1, 255, 10, BidibLibrary.BIDIB_PCFG_DIMM_DOWN,
                BidibLibrary.BIDIB_PCFG_DIMM_DOWN_8_8);
        tc.setCellRenderer(sliderRendererDimmMin);

        tc = getColumnModel().getColumn(LightPortTableModel.COLUMN_DIM_MAX);
        tc.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_DIM_MAX));

        ConfigXAwareSliderRenderer sliderRendererDimmMax =
            new ConfigXAwareSliderRenderer(1, 255, 10, BidibLibrary.BIDIB_PCFG_DIMM_UP,
                BidibLibrary.BIDIB_PCFG_DIMM_UP_8_8);
        tc.setCellRenderer(sliderRendererDimmMax);

        // Set the color renderer
        tc = getColumnModel().getColumn(LightPortTableModel.COLUMN_RGB);
        tc.setCellRenderer(new ColorRenderer(/* false */));
        tc.setMaxWidth(120);
        tc.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_RGB));

        tc = getColumnModel().getColumn(LightPortTableModel.COLUMN_TRANSITION_TIME);
        tc.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_TRANSITION_TIME));
        tc.setMaxWidth(80);
        tc.setCellRenderer(new PortAwareNumberRenderer());

        final TableColumn tcDmxMapping = getColumnModel().getColumn(LightPortTableModel.COLUMN_DMX_MAPPING);
        tcDmxMapping.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_DMX_MAPPING));
        tcDmxMapping.setMaxWidth(80);
        tcDmxMapping.setCellRenderer(new DmxChannelRenderer());

        tc = getColumnModel().getColumn(LightPortTableModel.COLUMN_PORT_IDENTIFIER);
        tc.setCellRenderer(new MappablePortTableCellRenderer());
        tc.setMaxWidth(80);
        tc.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_PORT_IDENTIFIER));

        // Set the status renderer
        tc = getColumnModel().getColumn(LightPortTableModel.COLUMN_STATUS);
        tc.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_STATUS));
        tc
            .setCellRenderer(new BidibStatusTableRenderer(LightPortStatus.class, "status.",
                LightPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.LIGHTPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        tc.setMinWidth(100);
        tc.setMaxWidth(120);

        final TableColumn buttonColumn = getColumnModel().getColumn(LightPortTableModel.COLUMN_TEST);
        buttonColumn.setIdentifier(Integer.valueOf(LightPortTableModel.COLUMN_TEST));
        buttonColumn.setMinWidth(180);
        buttonColumn.setMaxWidth(200);

        final PortComboBoxWithButtonEditorRenderer<BidibStatus> editor =
            new PortComboBoxWithButtonEditorRenderer<BidibStatus>(getActions(LightPortStatus.ON), ">",
                LightPortStatus.class, LightPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.LIGHTPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            };

        // editor.addButtonListener(new ButtonListener() {
        //
        // @Override
        // public void buttonPressed(int row, int column, Object value) {
        // LOGGER.info("The test button was pressed, row: {}, column: {}, value: {}", row, column, value);
        // getModel().setValueAt(value, row, LightPortTableModel.COLUMN_TEST);
        // }
        // });

        buttonColumn.setCellEditor(editor);
        buttonColumn.setCellRenderer(editor);

        TableColumnChooser.hideColumn(this, LightPortTableModel.COLUMN_PORT_INSTANCE);
    }
}
