package org.bidib.wizard.mvc.main.view.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

import org.bidib.wizard.client.common.view.editor.IntegerEditor;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.TicksAware;

public class PortTicksEditor extends IntegerEditor {

    private static final long serialVersionUID = 1L;

    private JPanel comp;

    private JLabel value;

    private final int portInstanceColumn;

    public PortTicksEditor(int portInstanceColumn, int min, int max) {
        super(min, max);
        this.portInstanceColumn = portInstanceColumn;

        comp = new JPanel();
        comp.setLayout(new BorderLayout());
        value = new JLabel();
        value.setMinimumSize(new Dimension(60, 12));
        value.setPreferredSize(new Dimension(70, 12));
        comp.add(value, BorderLayout.EAST);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Integer ticks = null;

        // get value at column 'int portInstanceColumn' must return the port
        final Port<?> port = (Port<?>) table.getModel().getValueAt(row, portInstanceColumn);

        if (port instanceof TicksAware) {
            TicksAware ticksAware = (TicksAware) port;
            value = ticksAware.getTicks();
            ticks = ticksAware.getTicks();
        }

        Component superComp = super.getTableCellEditorComponent(table, value, isSelected, row, column);

        if (ticks != null) {
            this.value.setText(String.format("(%d ms)", ticks * 10));
        }
        else {
            this.value.setText(null);
        }

        comp.add(superComp, BorderLayout.CENTER);

        return comp;
    }
}
