package org.bidib.wizard.mvc.nodedebug.model;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;

import javax.swing.UIManager;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleColor;

import com.jgoodies.binding.beans.Model;

public class DebugConsoleModel extends Model {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CONSOLE_CONTENT = "consoleContent";

    public static final String PROPERTY_CONSOLE_CONTENT_SIZE = "consoleContentSize";

    public static final String PROPERTY_SEND_TEXT = "sendText";

    public static final String PROPERTY_TRANSMIT_ENABLED = "transmitEnabled";

    private List<ConsoleLine> consoleMessages = new LinkedList<>();

    private String sendText;

    private NodeInterface selectedNode;

    private Color colorRed;

    private Color colorBlue;

    private Color colorGreen;

    private Color colorBlack;

    private Color colorGray;

    public static final class ConsoleLine {
        private final Color color;

        private final String message;

        public ConsoleLine(final Color color, final String message) {
            this.color = color;
            this.message = message;
        }

        /**
         * @return the color
         */
        public Color getColor() {
            return color;
        }

        /**
         * @return the message
         */
        public String getMessage() {
            return message;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
        }

    }

    public DebugConsoleModel() {
        this.colorRed = UIManager.getColor("Console.red");
        this.colorBlue = UIManager.getColor("Console.blue");
        this.colorGreen = UIManager.getColor("Console.green");
        this.colorBlack = UIManager.getColor("Console.black");
        this.colorGray = UIManager.getColor("Console.gray");
    }

    public void addConsoleLine(ConsoleColor consoleColor, String line) {
        Color color = this.colorBlack;
        switch (consoleColor) {
            case red:
                color = this.colorRed;
                break;
            case blue:
                color = this.colorBlue;
                break;
            case green:
                color = this.colorGreen;
                break;
            case gray:
                color = this.colorGray;
                break;
            default:
                break;
        }

        ConsoleLine consoleLine = new ConsoleLine(color, line);

        // only keep 250 in memory
        if (consoleMessages.size() > 250) {
            consoleMessages.remove(0);
        }

        consoleMessages.add(consoleLine);

        int index = consoleMessages.size() - 1;

        fireIndexedPropertyChange(PROPERTY_CONSOLE_CONTENT, index, null, consoleLine);
    }

    public void clear() {
        int oldSize = consoleMessages.size();

        consoleMessages.clear();

        firePropertyChange(PROPERTY_CONSOLE_CONTENT_SIZE, oldSize, consoleMessages.size());
    }

    /**
     * @return the sendText
     */
    public String getSendText() {
        return sendText;
    }

    /**
     * @param sendText
     *            the sendText to set
     */
    public void setSendText(String sendText) {
        String oldValue = this.sendText;
        this.sendText = sendText;
        firePropertyChange(PROPERTY_SEND_TEXT, oldValue, sendText);
    }

    /**
     * @return the selectedNode
     */
    public NodeInterface getSelectedNode() {
        return selectedNode;
    }

    /**
     * @param selectedNode
     *            the selectedNode to set
     */
    public void setSelectedNode(NodeInterface selectedNode) {
        boolean oldValue = isTransmitEnabled();

        this.selectedNode = selectedNode;
        boolean transmitEnabled = isTransmitEnabled();

        firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldValue, transmitEnabled);
    }

    public boolean isTransmitEnabled() {
        return getSelectedNode() != null && Feature
            .findFeature(getSelectedNode().getNode().getFeatures(),
                FeatureEnum.FEATURE_STRING_DEBUG.getNumber()) != null;
    }

}
