package org.bidib.wizard.mvc.ping.view;

import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.ping.model.NodePingModel;
import org.bidib.wizard.mvc.ping.model.NodePingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;

public class PingTableTableModel extends AbstractTableAdapter<NodePingModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingTableTableModel.class);

    private static final long serialVersionUID = 1L;

    public static final int COLUMN_UNIQUE_ID = 0;

    public static final int COLUMN_DESCRIPTION = 1;

    public static final int COLUMN_STATUS = 2;

    public static final int COLUMN_PING_INTERVAL = 3;

    public static final int COLUMN_ADDITIONAL_START_VALUE = 4;

    public static final int COLUMN_ADDITIONAL_FILL_BYTES_COUNT = 5;

    public static final int COLUMN_ADDITIONAL_TOTAL_BYTES_COUNT = 6;

    public static final int COLUMN_IDENTIFY_PROCESSING_WAIT_DURATION = 7;

    private static final String[] COLUMNNAMES =
        new String[] { Resources.getString(PingTableTableModel.class, "uniqueId"),
            Resources.getString(PingTableTableModel.class, "description"),
            Resources.getString(PingTableTableModel.class, "status"),
            Resources.getString(PingTableTableModel.class, "interval"),
            Resources.getString(PingTableTableModel.class, "additionalStartValue"),
            Resources.getString(PingTableTableModel.class, "additionalFillBytesCount"),
            Resources.getString(PingTableTableModel.class, "additionalTotalBytesCount"),
            Resources.getString(PingTableTableModel.class, "identifyProcessingWaitDuration") };

    public PingTableTableModel(SelectionInList<NodePingModel> nodeList) {
        super(nodeList, COLUMNNAMES);

        LOGGER.info("Current listModel: {}", getListModel());
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case COLUMN_UNIQUE_ID:
            case COLUMN_DESCRIPTION:
                return String.class;
            case COLUMN_PING_INTERVAL:
                return Integer.class;
            case COLUMN_ADDITIONAL_START_VALUE:
            case COLUMN_ADDITIONAL_FILL_BYTES_COUNT:
            case COLUMN_ADDITIONAL_TOTAL_BYTES_COUNT:
            case COLUMN_IDENTIFY_PROCESSING_WAIT_DURATION:
                return Integer.class;
            case COLUMN_STATUS:
                // return NodePingState.class;
            default:
                return Object.class;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case COLUMN_UNIQUE_ID:
                break;
            case COLUMN_STATUS:
                return true;
            case COLUMN_PING_INTERVAL:
                return true;
            case COLUMN_ADDITIONAL_START_VALUE:
            case COLUMN_ADDITIONAL_FILL_BYTES_COUNT:
            case COLUMN_ADDITIONAL_TOTAL_BYTES_COUNT:
            case COLUMN_IDENTIFY_PROCESSING_WAIT_DURATION:
                return true;
            default:
                break;
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        NodePingModel nodePingModel = getRow(rowIndex);
        switch (columnIndex) {
            case COLUMN_UNIQUE_ID:
                return ByteUtils.getUniqueIdAsString(nodePingModel.getNode().getUniqueId());
            case COLUMN_DESCRIPTION:
                return nodePingModel.getNodeLabel();
            case COLUMN_STATUS:
                return (nodePingModel.getNodePingState() == NodePingState.OFF ? false : true);
            case COLUMN_PING_INTERVAL:
                return nodePingModel.getPingInterval();
            case COLUMN_ADDITIONAL_START_VALUE:
                return nodePingModel.getAdditionalPayloadStartValue();
            case COLUMN_ADDITIONAL_FILL_BYTES_COUNT:
                return nodePingModel.getAdditionalFillBytesCount();
            case COLUMN_ADDITIONAL_TOTAL_BYTES_COUNT:
                return nodePingModel.getAdditionalTotalBytesCount();
            case COLUMN_IDENTIFY_PROCESSING_WAIT_DURATION:
                return nodePingModel.getIdentifyProcessingWaitDuration();
            default:
                return null;
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        LOGGER.info("Set the value: {}, rowIndex: {}", value, rowIndex);

        NodePingModel nodePingModel = getRow(rowIndex);
        switch (columnIndex) {
            case COLUMN_STATUS:
                if (value instanceof Boolean) {
                    Boolean val = (Boolean) value;
                    nodePingModel.setNodePingState(val.booleanValue() ? NodePingState.ON : NodePingState.OFF);
                }
                break;
            case COLUMN_PING_INTERVAL:
                if (value instanceof Integer) {
                    Integer pingInterval = (Integer) value;
                    nodePingModel.setPingInterval(pingInterval);
                }
                break;
            case COLUMN_ADDITIONAL_START_VALUE:
                if (value instanceof Integer) {
                    Integer additionalStartValue = (Integer) value;
                    nodePingModel.setAdditionalPayloadStartValue(additionalStartValue);
                }
                break;
            case COLUMN_ADDITIONAL_FILL_BYTES_COUNT:
                if (value instanceof Integer) {
                    Integer additionalFillBytesCount = (Integer) value;
                    nodePingModel.setAdditionalFillBytesCount(additionalFillBytesCount);
                }
                break;
            case COLUMN_ADDITIONAL_TOTAL_BYTES_COUNT:
                if (value instanceof Integer) {
                    Integer additionalTotalBytesCount = (Integer) value;
                    nodePingModel.setAdditionalTotalBytesCount(additionalTotalBytesCount);
                }
                break;
            case COLUMN_IDENTIFY_PROCESSING_WAIT_DURATION:
                if (value instanceof Integer) {
                    Integer identifyProcessingWaitDuration = (Integer) value;
                    nodePingModel.setIdentifyProcessingWaitDuration(identifyProcessingWaitDuration);
                }
                break;
            default:
                break;
        }
    }
}
