package org.bidib.wizard.mvc.preferences.view.panel;

import java.awt.BorderLayout;
import java.util.function.Consumer;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.ListModel;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.core.model.settings.WizardSettings;
import org.bidib.wizard.mvc.preferences.model.PreferencesModel;

import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public class WizardSettingsPanel extends AbstractSettingsPanel<WizardSettingsInterface> {

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, fill:50dlu:grow";

    private static final String ENCODED_DIALOG_ROW_SPECS =
        "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";

    private final PreferencesModel model;

    private final WizardSettingsInterface wizardSettings;

    private JPanel contentPanel;

    public WizardSettingsPanel(final PreferencesModel model, final WizardSettingsInterface wizardSettings,
        final Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.model = model;
        this.wizardSettings = wizardSettings;
    }

    public JPanel createPanel() {

        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            JPanel panel = new FormDebugPanel();
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        else {
            JPanel panel = new JPanel(new BorderLayout());
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        dialogBuilder.border(Paddings.TABBED_DIALOG);

        // use value model here and only update settings on focus lost
        preparePresentationModel(this.wizardSettings);

        // tip of the day
        final BufferedValueModel showTipOfDayModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_SHOW_TIP_OF_DAY);

        JCheckBox showTipOfDay =
            WizardComponentFactory.createCheckBox(showTipOfDayModel, Resources.getString(getClass(), "showTipOfDay"));

        dialogBuilder.add(showTipOfDay).xyw(1, 1, 1);

        // local ping enabled
        final BufferedValueModel localPingEnabledModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_LOCAL_PING_ENABLED);

        JCheckBox localPingEnabled =
            WizardComponentFactory
                .createCheckBox(localPingEnabledModel, Resources.getString(getClass(), "localPingEnabled"));

        dialogBuilder.add(localPingEnabled).xyw(1, 5, 1);

        // show action tab in last tab
        final BufferedValueModel showActionInLastTabModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_SHOW_ACTION_IN_LAST_TAB);

        JCheckBox showActionInLastTab =
            WizardComponentFactory
                .createCheckBox(showActionInLastTabModel, Resources.getString(getClass(), "showActionInLastTab"));

        dialogBuilder.add(showActionInLastTab).xy(1, 7);

        // all booster on do not confirm switch
        final BufferedValueModel allBoosterOnDoNotConfirmSwitchModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_ALL_BOOSTER_ON_DO_NOT_CONFIRM_SWITCH);

        JCheckBox allBoosterOnDoNotConfirmSwitch =
            WizardComponentFactory
                .createCheckBox(allBoosterOnDoNotConfirmSwitchModel,
                    Resources.getString(getClass(), "allBoosterOnDoNotConfirmSwitch"));

        dialogBuilder.add(allBoosterOnDoNotConfirmSwitch).xy(1, 9);

        // all booster on do not send soft stop
        final BufferedValueModel allBoosterOnDoNotSendSoftStopModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_ALL_BOOSTER_ON_DO_NOT_SEND_SOFTSTOP);

        JCheckBox allBoosterOnDoNotSendSoftStop =
            WizardComponentFactory
                .createCheckBox(allBoosterOnDoNotSendSoftStopModel,
                    Resources.getString(getClass(), "allBoosterOnDoNotSendSoftStop"));

        dialogBuilder.add(allBoosterOnDoNotSendSoftStop).xy(1, 11);

        // M4 support enabled
        final BufferedValueModel m4SupportEnabledModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_M4_SUPPORT_ENABLED);

        JCheckBox m4SupportEnabled =
            WizardComponentFactory
                .createCheckBox(m4SupportEnabledModel, Resources.getString(getClass(), "m4SupportEnabled"));

        dialogBuilder.add(m4SupportEnabled).xyw(1, 13, 1);

        // initialize loco decoders enabled
        final BufferedValueModel initializeLocoDecodersEnabledModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_INITIALIZE_LOCO_DECODERS_ENABLED);

        JCheckBox initializeLocoDecodersEnabled =
            WizardComponentFactory
                .createCheckBox(initializeLocoDecodersEnabledModel,
                    Resources.getString(getClass(), "initializeLocoDecodersEnabled"));

        dialogBuilder.add(initializeLocoDecodersEnabled).xyw(1, 15, 1);

        // perform reset after connect
        final BufferedValueModel performResetAfterConnectModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_PERFORM_RESET_AFTER_CONNECT);

        JCheckBox performResetAfterConnect =
            WizardComponentFactory
                .createCheckBox(performResetAfterConnectModel,
                    Resources.getString(getClass(), "performResetAfterConnect"));

        dialogBuilder.add(performResetAfterConnect).xyw(1, 17, 1);
        performResetAfterConnect.setEnabled(false);

        // node export append date enabled
        final BufferedValueModel nodeExportAppendDateEnabledModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_NODE_EXPORT_APPEND_DATE_ENABLED);

        JCheckBox nodeExportAppendDateEnabled =
            WizardComponentFactory
                .createCheckBox(nodeExportAppendDateEnabledModel,
                    Resources.getString(getClass(), "nodeExportAppendDateEnabled"));

        dialogBuilder.add(nodeExportAppendDateEnabled).xyw(1, 19, 1);

        ///// -------------------------------------------------------------------
        final BufferedValueModel selectionHolderLanguage =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_LANGUAGE);

        SelectionInList<String> languageSelection = new SelectionInList<>((ListModel<String>) model.getLanguageList());

        ComboBoxAdapter<String> comboBoxAdapterLanguage =
            new ComboBoxAdapter<>(languageSelection, selectionHolderLanguage);
        final JComboBox<String> comboLanguage = new JComboBox<>();
        comboLanguage.setModel(comboBoxAdapterLanguage);

        dialogBuilder.add(Resources.getString(getClass(), "language")).xy(3, 1);
        dialogBuilder.add(comboLanguage).xy(5, 1);

        // check for updates
        final BufferedValueModel checkForUpdatesEnabledModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_CHECK_FOR_UPDATES_ENABLED);

        JCheckBox checkForUpdatesEnabled =
            WizardComponentFactory
                .createCheckBox(checkForUpdatesEnabledModel, Resources.getString(getClass(), "checkForUpdatesEnabled"));

        dialogBuilder.add(checkForUpdatesEnabled).xyw(3, 3, 3);

        // power user
        final BufferedValueModel powerUserModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_POWER_USER);

        JCheckBox powerUser =
            WizardComponentFactory.createCheckBox(powerUserModel, Resources.getString(getClass(), "powerUser"));

        dialogBuilder.add(powerUser).xyw(3, 7, 3);

        // show booster table
        final BufferedValueModel showBoosterTableModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_SHOW_BOOSTER_TABLE);

        JCheckBox showBoosterTable =
            WizardComponentFactory
                .createCheckBox(showBoosterTableModel, Resources.getString(getClass(), "showBoosterTable"));

        dialogBuilder.add(showBoosterTable).xyw(3, 9, 3);

        // always show product name in tree
        final BufferedValueModel alwaysShowProductNameInTreeModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_ALWAYS_SHOW_PRODUCTNAME_IN_TREE);

        JCheckBox alwaysShowProductNameInTree =
            WizardComponentFactory
                .createCheckBox(alwaysShowProductNameInTreeModel,
                    Resources.getString(getClass(), "alwaysShowProductNameInTree"));

        dialogBuilder.add(alwaysShowProductNameInTree).xyw(3, 11, 3);

        // USB hotplug controller
        final BufferedValueModel useHotPlugControllerModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_USE_HOPLUG_CONTROLLER);

        JCheckBox useHotPlugController =
            WizardComponentFactory
                .createCheckBox(useHotPlugControllerModel, Resources.getString(getClass(), "useHotPlugController"));

        dialogBuilder.add(useHotPlugController).xyw(3, 13, 3);

        // Show new device alert
        final BufferedValueModel showNewDeviceAlertModel =
            presentationModel.getBufferedModel(WizardSettings.PROPERTY_SHOW_NEW_DEVICE_ALERT);

        JCheckBox showNewDeviceAlert =
            WizardComponentFactory
                .createCheckBox(showNewDeviceAlertModel, Resources.getString(getClass(), "showNewDeviceAlert"));

        dialogBuilder.add(showNewDeviceAlert).xyw(3, 15, 3);

        // append positions to position list instead of replace feedback position
        final BufferedValueModel appendToPositionListEnabledModel =
            presentationModel.getBufferedModel(WizardSettingsInterface.PROPERTY_APPEND_TO_POSITION_TABLE);

        JCheckBox appendToPositionListEnabled =
            WizardComponentFactory
                .createCheckBox(appendToPositionListEnabledModel,
                    Resources.getString(getClass(), "appendToPositionListEnabled"));
        appendToPositionListEnabled
            .setToolTipText(Resources.getString(getClass(), "appendToPositionListEnabled.tooltip"));

        dialogBuilder.add(appendToPositionListEnabled).xyw(3, 17, 3);

        // show RTXT view
        final BufferedValueModel showRxTxViewModel =
            presentationModel.getBufferedModel(WizardSettingsInterface.PROPERTY_SHOW_RXTX_VIEW);

        JCheckBox showRxTxView =
            WizardComponentFactory.createCheckBox(showRxTxViewModel, Resources.getString(getClass(), "showRxTxView"));

        dialogBuilder.add(showRxTxView).xyw(3, 19, 3);

        // show FW update warning
        final BufferedValueModel showFirmwareUpdateWarningModel =
            presentationModel.getBufferedModel(WizardSettingsInterface.PROPERTY_SHOW_FIRMWARE_UPDATE_WARNING);

        JCheckBox showFirmwareUpdateWarning =
            WizardComponentFactory
                .createCheckBox(showFirmwareUpdateWarningModel,
                    Resources.getString(getClass(), "showFirmwareUpdateWarning"));

        dialogBuilder.add(showFirmwareUpdateWarning).xyw(1, 21, 1);

        // show FW download warning
        final BufferedValueModel showFirmwareUpdateDownloadModel =
            presentationModel.getBufferedModel(WizardSettingsInterface.PROPERTY_SHOW_FIRMWARE_DOWNLOAD_WARNING);

        JCheckBox showFirmwareDownloadWarning =
            WizardComponentFactory
                .createCheckBox(showFirmwareUpdateDownloadModel,
                    Resources.getString(getClass(), "showFirmwareDownloadWarning"));

        dialogBuilder.add(showFirmwareDownloadWarning).xyw(3, 21, 3);

        contentPanel = dialogBuilder.build();
        contentPanel.setOpaque(false);
        return contentPanel;
    }

}
