package org.bidib.wizard.mvc.pt.controller.listener;

import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.model.status.CommandStationStatus;

public interface PtProgrammerControllerListener {

    /**
     * Close the view.
     */
    void close();

    /**
     * Send the PT request.
     * 
     * @param node
     *            the node
     * @param opCode
     *            the op code
     * @param cvNumber
     *            the CV number
     * @param cvValue
     *            the CV value
     */
    void sendRequest(final NodeInterface node, CommandStationPt opCode, int cvNumber, int cvValue);

    /**
     * Send the command station state request.
     * 
     * @param node
     *            the node
     * @param commandStationState
     *            the command station state
     */
    void sendCommandStationStateRequest(final NodeInterface node, CommandStationStatus commandStationState);

    /**
     * Get the current state of the command station.
     * 
     * @param node
     *            the node
     * @return the current command station state
     */
    CommandStationStatus getCurrentCommandStationState(final NodeInterface node);
}
