package org.bidib.wizard.mvc.stepcontrol.view;

import java.util.concurrent.Callable;
import java.util.function.Function;

import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;

public interface AspectCallbackListener<T> {

    /**
     * Activate the aspect.
     * 
     * @param stepControlAspect
     *            the aspect
     */
    void activateAspect(final T stepControlAspect);

    /**
     * Activate the opposite aspect.
     * 
     * @param stepControlAspect
     *            the aspect
     */
    void activateOppositeAspect(T stepControlAspect);

    /**
     * Save the changes.
     * 
     * @param originalAspect
     *            the aspect
     * @param func
     *            the callback function
     * @throws Exception
     */
    void saveChanges(final T originalAspect, Function<StepControlAspect, StepControlAspect> func) throws Exception;

    /**
     * Discard pending changes.
     * 
     * @param func
     *            the callback function
     * @throws Exception
     */
    void discardChanges(Callable<T> func) throws Exception;

    /**
     * Verify that the postition is unique.
     * 
     * @param originalAspect
     *            the aspect
     * @param position
     *            the position to verify
     * 
     * @param positionOpposite
     *            the opposite position to verify
     */
    void verifyUniquePosition(final T originalAspect, Long position, Long positionOpposite);

    /**
     * @return the current turntable position
     */
    Long getCurrentTurntablePosition();
}
