package org.bidib.wizard.mvc.stepcontrol.view;

import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;

import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;

import com.jgoodies.binding.list.IndirectListModel;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.HeaderStyleModel;
import com.jidesoft.grid.HierarchicalTableModel;
import com.jidesoft.grid.StyleModel;

public class AspectTableModel extends AbstractTableModel
    implements HierarchicalTableModel, StyleModel, HeaderStyleModel {

    private static final long serialVersionUID = 1L;

    public static final int COLUMN_ASPECT = 0;

    public static final int COLUMN_POSITION = 1;

    public static final int COLUMN_COUNT = COLUMN_POSITION + 1;

    private static final CellStyle ICON_COLLAPSED_STYLE = new CellStyle();

    private static final CellStyle ICON_EXPANDED_STYLE = new CellStyle();

    private final CellStyle cellStyle = new CellStyle();

    private final IndirectListModel<StepControlAspect> listModel;

    private final String[] columnNames;

    private final StepControlModel stepControlModel;

    private boolean collapsed;

    public AspectTableModel(final IndirectListModel<StepControlAspect> listModel, String[] columnNames,
        final StepControlModel stepControlModel) {
        this.listModel = listModel;
        this.columnNames = columnNames;
        this.stepControlModel = stepControlModel;

        cellStyle.setHorizontalAlignment(SwingConstants.TRAILING);

        ICON_COLLAPSED_STYLE.setHorizontalAlignment(SwingConstants.LEADING);
        ICON_COLLAPSED_STYLE.setIcon(UIManager.getIcon("Tree.collapsedIcon"));

        ICON_EXPANDED_STYLE.setHorizontalAlignment(SwingConstants.LEADING);
        ICON_EXPANDED_STYLE.setIcon(UIManager.getIcon("Tree.expandedIcon"));
    }

    public void removeAllRows() {

        listModel.getList().clear();

    }

    /**
     * Returns the column name.
     *
     * @return a name for this column using the string value of the appropriate member in
     *         <code>columnIdentifiers</code>. If <code>columnIdentifiers</code> does not have an entry for this index,
     *         returns the default name provided by the superclass.
     */
    @Override
    public String getColumnName(int column) {
        Object id = null;
        // This test is to cover the case when
        // getColumnCount has been subclassed by mistake ...
        if (column < columnNames.length && (column >= 0)) {
            id = columnNames[column];
        }
        return (id == null) ? super.getColumnName(column) : id.toString();
    }

    @Override
    public int getRowCount() {
        return listModel.getSize();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    private StepControlAspect getRow(int rowIndex) {
        return listModel.getElementAt(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex > COLUMN_ASPECT) {
            return true;
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {

        StepControlAspect stepControlAspect = getRow(rowIndex);
        switch (columnIndex) {
            case COLUMN_ASPECT:
            case COLUMN_POSITION:
                break;
            default:
                break;
        }
        return stepControlAspect;
    }

    @Override
    public CellStyle getCellStyleAt(int rowIndex, int columnIndex) {
        if (columnIndex < 2) {
            return cellStyle;
        }
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        return true;
    }

    @Override
    public boolean hasChild(int row) {
        return true;
    }

    @Override
    public boolean isHierarchical(int row) {
        return true;
    }

    @Override
    public Object getChildValueAt(int row) {
        return getRow(row);
    }

    @Override
    public boolean isExpandable(int row) {
        return true;
    }

    @Override
    public CellStyle getHeaderStyleAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (collapsed) {
                return ICON_COLLAPSED_STYLE;
            }
            return ICON_EXPANDED_STYLE;
        }
        return null;
    }

    @Override
    public boolean isHeaderStyleOn() {
        return true;
    }

    /**
     * @return the collapsed
     */
    public boolean isCollapsed() {
        return collapsed;
    }

    /**
     * @param collapsed
     *            the collapsed to set
     */
    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

}
