package org.bidib.wizard.mvc.stepcontrol.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

import org.bidib.wizard.mvc.common.view.table.CustomCheckBox;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect.Polarity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarityTableCellEditor extends AbstractCellEditor implements TableCellEditor, TableCellRenderer {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(PolarityTableCellEditor.class);

    private CustomCheckBox editor;

    private Polarity source;

    public PolarityTableCellEditor(String pathSelectedIcon, String pathUnselectedIcon) {
        this.editor = new CustomCheckBox(pathSelectedIcon, pathUnselectedIcon);
        this.editor.addActionListener(new LoadActionListener());
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    protected CustomCheckBox prepare(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!(value instanceof Polarity)) {
            source = null;
            editor.setEnabled(false);
            return null;
        }
        source = (Polarity) value;
        editor.setEnabled(true);

        editor.setSelected(source == Polarity.normal ? false : true);

        if (isSelected) {
            editor.setForeground(table.getSelectionForeground());
            editor.setBackground(table.getSelectionBackground());
        }
        else {
            editor.setForeground(table.getForeground());
            editor.setBackground(table.getBackground());
        }

        return editor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        CustomCheckBox button = prepare(table, value, isSelected, row, column);

        return button;
    }

    @Override
    public Object getCellEditorValue() {
        return source;
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return prepare(table, value, isSelected, row, column);
    }

    public class LoadActionListener implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent evt) {
            // Here, you need to make some decisions about what to do...
            // You have a reference to the File instance
            LOGGER.debug("Action was performed for source: {}", source);
            stopCellEditing();
        }

    }

}
