package org.bidib.wizard.mvc.stepcontrol.view;

public class PositionOutOfRangeException extends Exception {

    private static final long serialVersionUID = 1L;

    private final long position;

    private final long min;

    private final long max;

    private final int aspectNumber;

    public PositionOutOfRangeException(long position, long min, long max, int aspectNumber) {
        this.position = position;
        this.min = min;
        this.max = max;
        this.aspectNumber = aspectNumber;
    }

    public long getPosition() {
        return position;
    }

    public long getMin() {
        return min;
    }

    public long getMax() {
        return max;
    }

    public int getAspectNumber() {
        return aspectNumber;
    }

    @Override
    public String getMessage() {
        return toString();
    }

    @Override
    public String toString() {
        return "Invalid values detected in aspect " + aspectNumber + ": The position (" + position
            + ") is not in the allowed range (" + min + ".." + max + ")";
    }
}
