package org.bidib.wizard.mvc.stepcontrol.view;

import org.bidib.wizard.mvc.stepcontrol.model.MovementScaleEnum;

public class SpeedRangeValidationUtils {

    public static final long F_STEP_ACCEL_LIMIT = 19150L;

    public static final long F_STEP_ACCEL_LIMITx10 = 191500L;

    public static long calculateValidMaxSpeed(int microSteps, int totalSteps, MovementScaleEnum movementScaleEnum) {

        // calc max speed
        long maxSpeed = 360L * 1000000L;
        maxSpeed /= microSteps;
        maxSpeed /= totalSteps;
        maxSpeed /= 40L;

        if (movementScaleEnum == MovementScaleEnum.scale1) {
            maxSpeed = maxSpeed * 10;
        }

        return maxSpeed;
    }

    public static long calculateValidAccelarationFactor(int microSteps, int totalSteps) {
        long accelarationFactor = (long) microSteps * totalSteps;
        return accelarationFactor;
    }
}
