package org.bidib.wizard.mvc.stepcontrol.view;

import java.awt.Dimension;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.common.view.icon.AnimatedIcon;
import org.bidib.wizard.mvc.common.view.icon.LinearMovingIcon;
import org.bidib.wizard.mvc.common.view.icon.PendularMovingIcon;
import org.bidib.wizard.mvc.common.view.icon.RotateLabel;
import org.bidib.wizard.mvc.common.view.icon.RotatedIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurntableIconPanel extends JLayeredPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurntableIconPanel.class);

    private static final long serialVersionUID = 1L;

    private final ImageIcon turntableBackgroundRoundIcon;

    private final ImageIcon turntableBackgroundLinearIcon;

    private final ImageIcon turntableBackgroundPendularIcon;

    private final ImageIcon turntableBasicIcon;

    private final ImageIcon turntablePendularIcon;

    private TurnTableType turnTableType;

    private double degree;

    private AnimatedIcon turntableIcon;

    private RotateLabel turntableComponent;

    public TurntableIconPanel(ImageIcon turntableBackgroundRoundIcon, ImageIcon turntableBackgroundLinearIcon,
        ImageIcon turntableBackgroundPendularIcon, ImageIcon turntableBasicIcon, ImageIcon turntablePendularIcon,
        double degree, TurnTableType turnTableType) {

        this.turntableBackgroundRoundIcon = turntableBackgroundRoundIcon;
        this.turntableBackgroundLinearIcon = turntableBackgroundLinearIcon;
        this.turntableBackgroundPendularIcon = turntableBackgroundPendularIcon;
        this.turntableBasicIcon = turntableBasicIcon;
        this.turntablePendularIcon = turntablePendularIcon;
        this.degree = degree;
        this.turnTableType = turnTableType;
    }

    public void prepareComponent() {

        // remove all existing components from the layered pane
        removeAll();

        ImageIcon selectedBackgroundIcon = null;
        switch (turnTableType) {
            case round:
                selectedBackgroundIcon = turntableBackgroundRoundIcon;
                break;
            case linear:
                selectedBackgroundIcon = turntableBackgroundLinearIcon;
                break;
            case pendular:
                selectedBackgroundIcon = turntableBackgroundPendularIcon;
                break;
            default:
                selectedBackgroundIcon = turntableBackgroundLinearIcon;
                break;
        }
        JLabel backgroundLabel = new JLabel(selectedBackgroundIcon);
        backgroundLabel.setOpaque(true);

        // backgroundLabel.setBackground(Color.GREEN);
        backgroundLabel
            .setPreferredSize(
                new Dimension(selectedBackgroundIcon.getIconWidth(), selectedBackgroundIcon.getIconHeight()));
        backgroundLabel.setBounds(0, 0, selectedBackgroundIcon.getIconWidth(), selectedBackgroundIcon.getIconHeight());
        add(backgroundLabel, Integer.valueOf(10));

        switch (turnTableType) {
            case round:
                turntableIcon = new RotatedIcon(turntableBasicIcon, degree, true) {
                    @Override
                    public int getIconWidth() {
                        return getIconHeight();
                    };
                };
                break;
            case linear:
                turntableIcon = new LinearMovingIcon(turntableBasicIcon, degree) {
                    @Override
                    public int getIconWidth() {
                        return getIconHeight();
                    };
                };
                break;
            case pendular:
                turntableIcon = new PendularMovingIcon(turntablePendularIcon, degree) {
                    @Override
                    public int getIconWidth() {
                        return getIconHeight();
                    };
                };
                break;
            default:
                turntableIcon = null;
                break;
        }

        if (turntableIcon != null) {
            turntableComponent = new RotateLabel(turntableIcon);
            turntableComponent
                .setPreferredSize(new Dimension(selectedBackgroundIcon.getIconWidth() - 10,
                    selectedBackgroundIcon.getIconHeight() - 10));

            turntableComponent
                .setBounds(5, 5, selectedBackgroundIcon.getIconWidth() - 10,
                    selectedBackgroundIcon.getIconHeight() - 10);
            turntableComponent.setOpaque(false);

            add(turntableComponent, Integer.valueOf(20));
        }
    }

    public void setDegrees(double degree) {
        this.degree = degree;
        if (turntableIcon != null) {
            turntableIcon.setDegrees(degree);
        }
    }

    /**
     * @param turnTableType
     *            the turnTableType to set
     */
    public void setTurnTableType(TurnTableType turnTableType) {
        TurnTableType oldValue = this.turnTableType;

        this.turnTableType = turnTableType;

        if (oldValue != this.turnTableType) {
            LOGGER.info("The turnTableType has changed, rebuild the component. New type: {}", this.turnTableType);

            prepareComponent();

            repaintTurntable();
        }
    }

    public void repaintTurntable() {
        // LOGGER.info("repaint, turntableComponent: {}", turntableComponent);
        if (turntableComponent != null) {
            turntableComponent.repaint();
        }

    }

}
