package org.bidib.wizard.mvc.tips.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.tipoftheday.TipOfTheDaySource;

public class FileTipOfTheDaySource implements TipOfTheDaySource {

    private static final Logger LOGGER = LoggerFactory.getLogger(FileTipOfTheDaySource.class);

    private Map<Integer, String> tips;

    private int maxTipIndex;

    private int currentTipIndex;

    public FileTipOfTheDaySource(final InputStream input) throws IOException {
        this.tips = new HashMap<>();

        final Properties props = new Properties();
        props.load(input);

        for (Entry<Object, Object> entry : props.entrySet()) {
            // parse the entry values and store in tips
            try {
                Integer key = Integer.valueOf(entry.getKey().toString());
                String value = entry.getValue().toString();
                tips.put(key, value);
            }
            catch (Exception ex) {
                LOGGER.warn("Parse tip failed: {}", entry);
            }
        }

        // determine the maximum index
        Integer maxIndex = this.tips.keySet().stream().max((entry1, entry2) -> entry1 > entry2 ? 1 : -1).get();

        this.maxTipIndex = maxIndex.intValue();
        LOGGER.info("Prepared maxTipIndex: {}", maxTipIndex);
    }

    @Override
    public int getCurrentTipIndex() {
        return currentTipIndex;
    }

    @Override
    public void setCurrentTipIndex(int currentTipIndex) {
        this.currentTipIndex = currentTipIndex;
    }

    @Override
    public String getNextTip() {

        int prevIndex = this.currentTipIndex;

        do {
            this.currentTipIndex++;

            // check if the upper limit is reached
            if (this.currentTipIndex > maxTipIndex) {
                this.currentTipIndex = 0;
            }

            String rawTip = getTip(this.currentTipIndex);
            if (rawTip != null) {
                return "<html><body>" + rawTip + "</body></html>";
            }
        }
        while (this.currentTipIndex != prevIndex);

        return null;
    }

    private String getTip(int index) {
        String rawTip = this.tips.get(Integer.valueOf(index));
        return rawTip;
    }

    @Override
    public String getPreviousTip() {

        int prevIndex = this.currentTipIndex;

        do {
            this.currentTipIndex--;
            if (this.currentTipIndex < 0) {
                this.currentTipIndex = maxTipIndex;
            }
            String rawTip = getTip(this.currentTipIndex);
            if (rawTip != null) {
                return "<html><body>" + rawTip + "</body></html>";
            }
        }
        while (this.currentTipIndex != prevIndex);

        return null;
    }

}
