package org.bidib.wizard.mvc.worklist.controller.actions;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

import org.bidib.wizard.api.event.WizardUpdateWorkListItemEvent;
import org.bidib.wizard.api.event.WorkListItemEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.exception.UserActionAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vlsolutions.swing.docking.DockingDesktop;

public class DownloadWizardAction implements WorkListAction<WizardUpdateWorkListItemEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadWizardAction.class);

    public DownloadWizardAction() {
    }

    @Override
    public void apply(DockingDesktop desktop, WizardUpdateWorkListItemEvent actionEvent)
        throws UserActionAbortedException {

        LOGGER.info("Let the wizard update service download the new installer.");
        String downloadUrl = actionEvent.getDownloadUrl();

        String okButtonText = UIManager.getString("OptionPane.okButtonText");
        String noButtonText = Resources.getString(DownloadWizardAction.class, "download-new-installer.ignore");
        String cancelButtonText = UIManager.getString("OptionPane.cancelButtonText");

        int result =
            JOptionPane
                .showOptionDialog(JOptionPane.getFrameForComponent(desktop.getRootPane()),
                    Resources.getString(DownloadWizardAction.class, "download-new-installer.text", downloadUrl),
                    Resources.getString(DownloadWizardAction.class, "download-new-installer.title"),
                    JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, (Icon) null,
                    new Object[] { okButtonText, noButtonText, cancelButtonText }, null);

        if (result == JOptionPane.YES_OPTION) {
            LOGGER.info("Download the new installer to the local directory: {}", downloadUrl);

            try {
                Desktop.getDesktop().browse(URI.create(downloadUrl));
            }
            catch (IOException ex) {
                LOGGER.warn("Download the new installer to the local directory failed.", ex);
                throw new UserActionAbortedException("Download the new installer to the local directory failed.");
            }
        }
        else if (result == JOptionPane.NO_OPTION) {
            LOGGER.info("User does not want to download the new installer. Set the status to ignore.");
            actionEvent.setStatus(WorkListItemEvent.Status.ignore);
        }
        else {
            LOGGER.info("Download the new installer to the local directory was cancelled.");
            throw new UserActionAbortedException("Download the new installer to the local directory was cancelled.");
        }
    }

}
