package org.bidib.wizard.mvc.worklist.model;

import org.bidib.wizard.api.event.WorkListItemEvent;

import com.jgoodies.binding.beans.Model;

public class WorkItemModel extends Model {

    private static final long serialVersionUID = 1L;

    private final WorkListItemEvent workListItemEvent;

    public WorkItemModel(final WorkListItemEvent workListItemEvent) {
        this.workListItemEvent = workListItemEvent;
    }

    public WorkListItemEvent getWorkListItemEvent() {
        return workListItemEvent;
    }

    public String getComponent() {
        return this.workListItemEvent.getComponent();
    }

    public String getAction() {
        return this.workListItemEvent.getAction();
    }

    public boolean isIgnored(final WorkListItemEvent other) {
        return this.workListItemEvent.isIgnored(other);
    }
}
