package org.bidib.wizard.mvc.worklist.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.worklist.view.ButtonActionData.ActionEnum;

import com.jidesoft.grid.AbstractTableCellEditorRenderer;
import com.jidesoft.grid.CellRolloverSupport;
import com.jidesoft.swing.JideButton;

public class ButtonsCellEditorRenderer extends AbstractTableCellEditorRenderer implements CellRolloverSupport {
    private static final long serialVersionUID = 1L;

    private static final int ICON_HEIGHT = 16;

    final ImageIcon removeIcon =
        ImageUtils
            .loadImageIcon(ButtonsCellEditorRenderer.class, "/icons/16x16/remove_package.png", ICON_HEIGHT,
                ICON_HEIGHT);

    final ImageIcon removeRolloverIcon =
        ImageUtils
            .loadImageIcon(ButtonsCellEditorRenderer.class, "/icons/16x16/remove_package_rollover.png", ICON_HEIGHT,
                ICON_HEIGHT);

    final ImageIcon editIcon =
        ImageUtils.loadImageIcon(ButtonsCellEditorRenderer.class, "/icons/16x16/wrench.png", ICON_HEIGHT, ICON_HEIGHT);

    final ImageIcon editRolloverIcon =
        ImageUtils
            .loadImageIcon(ButtonsCellEditorRenderer.class, "/icons/16x16/wrench_rollover.png", ICON_HEIGHT,
                ICON_HEIGHT);

    private final Consumer<ButtonActionData> actionCallback;

    public ButtonsCellEditorRenderer(final Consumer<ButtonActionData> actionCallback) {
        this.actionCallback = actionCallback;
    }

    @Override
    public Component createTableCellEditorRendererComponent(JTable table, int row, int column) {
        // JPanel panel = new JPanel(new GridLayout(1, 2));
        final JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));
        panel.setOpaque(true);
        panel
            .add(createButton(editIcon, editRolloverIcon,
                Resources.getString(ButtonsCellEditorRenderer.class, "edit.tooltip")));
        panel.add(Box.createRigidArea(new Dimension(3, 0)));
        panel
            .add(createButton(removeIcon, removeRolloverIcon,
                Resources.getString(ButtonsCellEditorRenderer.class, "remove.tooltip")));
        return panel;
    }

    @Override
    public void configureTableCellEditorRendererComponent(
        final JTable table, Component editorRendererComponent, boolean forRenderer, Object value, boolean isSelected,
        boolean hasFocus, final int row, int column) {
        if (!forRenderer) {
            JButton editButton = (JButton) (((JPanel) editorRendererComponent).getComponent(0));
            editButton.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ButtonsCellEditorRenderer.this.actionCallback != null) {
                        ButtonsCellEditorRenderer.this.actionCallback
                            .accept(new ButtonActionData(row, ActionEnum.EDIT));
                    }
                }
            });

            JButton removeButton = (JButton) (((JPanel) editorRendererComponent).getComponent(2));
            removeButton.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ButtonsCellEditorRenderer.this.actionCallback != null) {
                        ButtonsCellEditorRenderer.this.actionCallback
                            .accept(new ButtonActionData(row, ActionEnum.DELETE));
                    }
                }
            });
        }
        editorRendererComponent.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        editorRendererComponent.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isRollover(JTable table, MouseEvent e, int row, int column) {
        return true;
    }

    private JButton createButton(Icon icon, Icon rolloverIcon, String toolTipText) {
        JButton button = new JideButton(icon);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setPreferredSize(new Dimension(ICON_HEIGHT, ICON_HEIGHT));
        button.setMaximumSize(new Dimension(ICON_HEIGHT, ICON_HEIGHT));
        button.setMinimumSize(new Dimension(ICON_HEIGHT, ICON_HEIGHT));
        button.setContentAreaFilled(false);
        button.setRolloverIcon(rolloverIcon);
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setRequestFocusEnabled(false);
        button.setToolTipText(toolTipText);
        return button;
    }

}
