package org.bidib.wizard.mvc.main.controller;

import org.assertj.core.api.Assertions;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.model.ports.LightPort;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class LightPortPanelControllerTest {

    private LightPortPanelController controller = new LightPortPanelController(null, event -> {
    }, Mockito.mock(StatusBar.class));

    @Test
    public void testValidRange() {
        final LightPort firstPort = new LightPort();
        firstPort.setId(59);
        int portsCount = 2;
        Integer channelBStartWS28xxNumber = Integer.valueOf(20);

        Integer upperRangeValue = controller.testValidRange(firstPort, portsCount, channelBStartWS28xxNumber);

        Assertions.assertThat(upperRangeValue).isNotNull();
        Assertions.assertThat(upperRangeValue).isEqualTo(Integer.valueOf(channelBStartWS28xxNumber * 3));
    }

    @Test
    public void testValidRange2() {
        final LightPort firstPort = new LightPort();
        firstPort.setId(58);
        int portsCount = 2;
        Integer channelBStartWS28xxNumber = Integer.valueOf(20);

        Integer upperRangeValue = controller.testValidRange(firstPort, portsCount, channelBStartWS28xxNumber);

        Assertions.assertThat(upperRangeValue).isNotNull();
        Assertions.assertThat(upperRangeValue).isEqualTo(Integer.valueOf(channelBStartWS28xxNumber * 3));
    }

    @Test
    public void testValidRangeInChannelB() {
        final LightPort firstPort = new LightPort();
        firstPort.setId(63);
        int portsCount = 4;
        Integer channelBStartWs28xxNumber = Integer.valueOf(20);

        Integer upperRangeValue = controller.testValidRange(firstPort, portsCount, channelBStartWs28xxNumber);

        Assertions.assertThat(upperRangeValue).isNull();
    }

    @Test
    public void testValidRangeInChannelB2() {
        final LightPort firstPort = new LightPort();
        firstPort.setId(60);
        int portsCount = 4;
        Integer channelBStartWs28xxNumber = Integer.valueOf(20);

        Integer upperRangeValue = controller.testValidRange(firstPort, portsCount, channelBStartWs28xxNumber);

        Assertions.assertThat(upperRangeValue).isNull();
    }
}
