/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.client.common.nodetree.JideNodeTree;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.main.controller.MacroPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SelectedMacroModel;
import org.bidib.wizard.mvc.main.view.menu.listener.MacroListMenuListener;
import org.bidib.wizard.mvc.main.view.panel.MacroContentPanel;
import org.bidib.wizard.mvc.main.view.panel.MacroListPanel;
import org.bidib.wizard.mvc.main.view.panel.MacroPanel;
import org.bidib.wizard.mvc.main.view.panel.MacroParameterPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroPanel.class);
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref, 3dlu, fill:200px:grow, 3dlu, pref";
    private final MacroPanelController macroPanelController;
    private final MainModel mainModel;
    private final SettingsService settingsService;
    private final MacroListMenuListener macroListMenuListener;
    private final SelectedMacroModel selectedMacroModel;
    private final ValueModel selectedMacroValueModel;
    private final PropertyChangeListener labelChangedListener;
    private final MacroParameterPanel macroParameterPanel;
    private final MacroContentPanel macroContentPanel;
    private final JPanel buttonPanel;
    private Boolean showPowerUser;
    private final Icon bidibLeafWarnIcon;
    private int permanentMacroSave;
    private JButton saveButton;

    public MacroPanel(MacroPanelController macroPanelController, MainModel mainModel, SettingsService settingsService, MacroListMenuListener macroListMenuListener) {
        this.macroPanelController = macroPanelController;
        this.mainModel = mainModel;
        this.settingsService = settingsService;
        this.macroListMenuListener = macroListMenuListener;
        this.setLayout((LayoutManager)new BorderLayout());
        this.selectedMacroModel = new SelectedMacroModel();
        this.labelChangedListener = new /* Unavailable Anonymous Inner Class!! */;
        this.bidibLeafWarnIcon = ImageUtils.createImageIcon(JideNodeTree.class, (String)"/icons/warn.png", (int)16, (int)16);
        FormBuilder formBuilder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]);
        formBuilder.border(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.selectedMacroValueModel = new PropertyAdapter((Object)this.selectedMacroModel, "selectedMacro", true);
        ConverterValueModel valueConverterModel = new ConverterValueModel(this.selectedMacroValueModel, (BindingConverter)new MacroConverter());
        JLabel selectedMacroLabel = WizardComponentFactory.createLabel((ValueModel)valueConverterModel);
        formBuilder.add(Resources.getString(MacroListPanel.class, (String)"macroName"), new Object[0]).xy(1, 1);
        formBuilder.add((Component)selectedMacroLabel).xyw(3, 1, 3);
        this.macroParameterPanel = new MacroParameterPanel(mainModel);
        formBuilder.add((Component)this.macroParameterPanel).xyw(1, 3, 5);
        this.macroContentPanel = new MacroContentPanel(mainModel);
        formBuilder.add((Component)this.macroContentPanel).xyw(1, 5, 5);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 0, 5, 0));
        formBuilder.add((Component)this.buttonPanel).xyw(1, 7, 5);
        this.createAndAddButtonPanel(this.settingsService.getWizardSettings().isPowerUser());
        this.revalidateSaveButton(this.permanentMacroSave);
        this.add((Component)formBuilder.build(), (Object)"Center");
        this.mainModel.addMacroSelectionListener(() -> {
            Macro macro;
            LOGGER.info("The selected macro has changed.");
            Macro selectedAccessory = this.selectedMacroModel.getSelectedMacro();
            if (selectedAccessory != null) {
                selectedAccessory.removePropertyChangeListener("label", this.labelChangedListener);
            }
            if ((macro = this.mainModel.getSelectedMacro()) != null) {
                macro.addPropertyChangeListener("label", this.labelChangedListener);
            } else {
                LOGGER.info("No macro selected.");
                this.selectedMacroModel.triggerLabelChanged();
            }
            this.selectedMacroModel.setSelectedMacro(macro);
        });
        try {
            WizardSettingsInterface ws = this.settingsService.getWizardSettings();
            ws.addPropertyChangeListener("powerUser", evt -> {
                Object value = evt.getNewValue();
                if (value instanceof Boolean) {
                    boolean powerUser = (Boolean)value;
                    LOGGER.info("The power user flag has changed: {}", (Object)powerUser);
                    this.createAndAddButtonPanel(powerUser);
                    this.revalidateSaveButton(this.permanentMacroSave);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Add property change listeners failed.", (Throwable)ex);
        }
    }

    private void createAndAddButtonPanel(boolean isPowerUser) {
        if (this.buttonPanel != null && this.showPowerUser == Boolean.valueOf(isPowerUser)) {
            LOGGER.info("Power user flag has not changed.");
            return;
        }
        this.showPowerUser = isPowerUser;
        if (isPowerUser) {
            this.preparePowerUserButtonPanel(this.buttonPanel);
        } else {
            this.prepareNormalUserButtonPanel(this.buttonPanel);
        }
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    private JPanel prepareNormalUserButtonPanel(JPanel buttonPanel) {
        buttonPanel.removeAll();
        JButton reloadButton = new JButton(Resources.getString(MacroListPanel.class, (String)"load"));
        reloadButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"load.tooltip"));
        reloadButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(reloadButton);
        this.saveButton = new JButton(Resources.getString(MacroListPanel.class, (String)"save"));
        this.saveButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"save.tooltip"));
        this.saveButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(this.saveButton);
        JButton testButton = new JButton(Resources.getString(MacroListPanel.class, (String)"test"));
        testButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"test.tooltip"));
        testButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(testButton);
        JButton stopButton = new JButton(Resources.getString(MacroListPanel.class, (String)"stop"));
        stopButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"stop.tooltip"));
        stopButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(stopButton);
        return buttonPanel;
    }

    private JPanel preparePowerUserButtonPanel(JPanel buttonPanel) {
        buttonPanel.removeAll();
        JButton reloadButton = new JButton(Resources.getString(MacroListPanel.class, (String)"reload"));
        reloadButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"reload.tooltip"));
        reloadButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(reloadButton);
        JButton transferButton = new JButton(Resources.getString(MacroListPanel.class, (String)"transfer"));
        transferButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"transfer.tooltip"));
        transferButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(transferButton);
        JButton testButton = new JButton(Resources.getString(MacroListPanel.class, (String)"testPower"));
        testButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"testPower.tooltip"));
        testButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(testButton);
        JButton stopButton = new JButton(Resources.getString(MacroListPanel.class, (String)"stop"));
        stopButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"stop.tooltip"));
        stopButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(stopButton);
        this.saveButton = new JButton(Resources.getString(MacroListPanel.class, (String)"save"));
        this.saveButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"save.tooltip"));
        this.saveButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(this.saveButton);
        JButton remoteStartButton = new JButton(Resources.getString(MacroListPanel.class, (String)"remoteStart"));
        remoteStartButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"remoteStart.tooltip"));
        remoteStartButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add(remoteStartButton);
        return buttonPanel;
    }

    public void refreshView() {
        LOGGER.info("Refresh the macro panel.");
        this.macroContentPanel.refreshView();
    }

    public void updateMacroSaveCount(int macroSaveValue) {
        LOGGER.info("Handle update of the macro save count value: {}", (Object)macroSaveValue);
        if (macroSaveValue != this.permanentMacroSave) {
            this.revalidateSaveButton(macroSaveValue);
            this.permanentMacroSave = macroSaveValue;
        }
    }

    private void revalidateSaveButton(int macroSaveValue) {
        if (this.saveButton != null) {
            LOGGER.info("The permanent macro save has been changed -> refresh the save button.");
            if (this.showPowerUser.booleanValue()) {
                this.saveButton.setEnabled(macroSaveValue > 0);
                this.saveButton.setIcon(null);
            } else if (macroSaveValue > 0) {
                this.saveButton.setText(Resources.getString(MacroListPanel.class, (String)"save"));
                this.saveButton.setIcon(null);
                this.saveButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"save.tooltip"));
            } else {
                this.saveButton.setText(Resources.getString(MacroListPanel.class, (String)"save-not-permanent"));
                this.saveButton.setIcon(this.bidibLeafWarnIcon);
                this.saveButton.setToolTipText(Resources.getString(MacroListPanel.class, (String)"save-not-permanent.tooltip"));
            }
        }
    }
}

