/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.statusbar;

import com.jidesoft.status.StatusBarItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.bidib.wizard.client.common.led.LED;
import org.bidib.wizard.client.common.uils.SwingUtils;

public class ConnectionProviderStatusBarItem
extends StatusBarItem {
    private static final long serialVersionUID = 1L;
    private final LED mdnsLed;
    private final JLabel label;

    public ConnectionProviderStatusBarItem() {
        this.setLayout((LayoutManager)new BorderLayout(3, 0));
        Color colorOn = UIManager.getColor("ConnectionProviderStatusBarItem.led_on");
        Color colorOff = UIManager.getColor("ConnectionProviderStatusBarItem.led_off");
        if (colorOn == null) {
            colorOn = Color.blue;
        }
        if (colorOff == null) {
            colorOff = Color.gray;
        }
        this.mdnsLed = new LED(colorOn, colorOff, 1000);
        this.mdnsLed.setName("mDNS");
        this.mdnsLed.setPreferredSize(new Dimension(5, 10));
        this.label = new JLabel();
        this.add((Component)this.mdnsLed, (Object)"West");
        this.add((Component)this.label, (Object)"Center");
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void setToolTipText(String tooltipText) {
        this.label.setToolTipText(tooltipText);
    }

    public String getItemName() {
        return "ConnectionProviderStatusBarItem";
    }

    public void setDiscoveryEnabled(boolean discoveryEnabled) {
        SwingUtils.executeInEDT(() -> this.setLedState(discoveryEnabled));
    }

    private void setLedState(boolean discoveryEnabled) {
        if (discoveryEnabled) {
            this.mdnsLed.usePrimary();
        } else {
            this.mdnsLed.useSecondary();
        }
    }
}

