/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberWithLabelEditor
extends AbstractCellEditor
implements TableCellEditor,
RangeValidationCallback {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberWithLabelEditor.class);
    private final JPanel panel = new JPanel();
    private final JFormattedTextField textField;
    private final JLabel leftLabel;
    private final JLabel rightLabel;
    private int minimum;
    private int maximum;

    public NumberWithLabelEditor(String leftText, String rightText, int maximum) {
        this.maximum = maximum;
        this.textField = new JFormattedTextField();
        IntegerInputValidationDocument doc = new IntegerInputValidationDocument(3, "0123456789");
        doc.setRangeValidationCallback((RangeValidationCallback)this);
        this.textField.setDocument((Document)doc);
        this.textField.setHorizontalAlignment(4);
        Dimension currentDim = this.textField.getPreferredSize();
        this.textField.setPreferredSize(new Dimension(30, currentDim.height));
        this.textField.setMinimumSize(new Dimension(30, currentDim.height));
        this.leftLabel = new JLabel(leftText);
        this.leftLabel.setFocusable(false);
        this.rightLabel = new JLabel(rightText);
        this.rightLabel.setFocusable(false);
        this.panel.setFocusCycleRoot(true);
        this.panel.setLayout(new BoxLayout(this.panel, 2));
        this.panel.add(this.leftLabel);
        this.panel.add(this.textField);
        this.panel.add(this.rightLabel);
    }

    public NumberWithLabelEditor(String leftText, String rightText) {
        this(leftText, rightText, 255);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.panel.setForeground(table.getSelectionForeground());
            this.panel.setBackground(table.getSelectionBackground());
        } else {
            this.panel.setForeground(table.getForeground());
            this.panel.setBackground(table.getBackground());
        }
        LOGGER.debug("Set value in editor: {}", value);
        this.textField.setText(value != null ? value.toString() : "");
        return this.panel;
    }

    @Override
    public Object getCellEditorValue() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.textField.getText())) {
                return Integer.parseInt(this.textField.getText());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Parse textfield value failed.", (Throwable)ex);
        }
        return 0;
    }

    public int getMinValue() {
        return this.minimum;
    }

    public int getMaxValue() {
        return this.maximum;
    }

    public void showValidationMarker(boolean show) {
    }
}

