/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ping.view;

import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.editor.HexIntegerEditor;
import org.bidib.wizard.client.common.view.editor.IntegerEditor;
import org.bidib.wizard.client.common.view.renderer.HexIntegerRenderer;
import org.bidib.wizard.mvc.common.view.table.CustomBooleanCellEditor;
import org.bidib.wizard.mvc.common.view.table.CustomBooleanCellRenderer;
import org.bidib.wizard.mvc.ping.model.NodePingModel;
import org.bidib.wizard.mvc.ping.model.PingTableModel;
import org.bidib.wizard.mvc.ping.view.PingIntervalRenderer;
import org.bidib.wizard.mvc.ping.view.PingTableTableModel;
import org.bidib.wizard.mvc.ping.view.PingTableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingTableView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingTableView.class);
    private final JPanel contentPanel;
    private SelectionInList<NodePingModel> nodeSelection;

    public PingTableView(PingTableModel pingTableModel) {
        DockKeys.DOCKKEY_PING_TABLE_VIEW.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_PING_TABLE_VIEW.setFloatEnabled(true);
        DockKeys.DOCKKEY_PING_TABLE_VIEW.setAutoHideEnabled(false);
        LOGGER.info("Create new PingTableView");
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.nodeSelection = new SelectionInList((ListModel)pingTableModel.getNodeListModel());
        PingTableTableModel tableModel = new PingTableTableModel(this.nodeSelection);
        1 pingTable = new /* Unavailable Anonymous Inner Class!! */;
        pingTable.adjustRowHeight();
        pingTable.setSelectionModel((ListSelectionModel)new SingleListSelectionAdapter(this.nodeSelection.getSelectionIndexHolder()));
        pingTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        TableColumnModel tcm = pingTable.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setMinWidth(120);
        tc.setMaxWidth(150);
        tc.setPreferredWidth(150);
        tc = tcm.getColumn(1);
        tc.setPreferredWidth(300);
        tc = tcm.getColumn(2);
        tc.setCellEditor((TableCellEditor)new CustomBooleanCellEditor("/icons/accessory-successful.png", "/icons/cross.png"));
        tc.setCellRenderer((TableCellRenderer)new CustomBooleanCellRenderer("/icons/accessory-successful.png", "/icons/cross.png"));
        tc.setMaxWidth(60);
        tc = tcm.getColumn(3);
        IntegerEditor pingIntervalEditor = new IntegerEditor(20, 20000);
        tc.setCellEditor((TableCellEditor)pingIntervalEditor);
        tc.setCellRenderer((TableCellRenderer)new PingIntervalRenderer());
        tc = tcm.getColumn(4);
        InputValidationDocument numericDocument = new InputValidationDocument(2, "0123456789ABCDEF");
        numericDocument.setDocumentFilter((DocumentFilter)new /* Unavailable Anonymous Inner Class!! */);
        HexIntegerEditor additionalStartValueEditor = new HexIntegerEditor((Document)numericDocument, 4);
        tc.setCellEditor((TableCellEditor)additionalStartValueEditor);
        tc.setCellRenderer((TableCellRenderer)new HexIntegerRenderer());
        tc = tcm.getColumn(5);
        IntegerEditor additionalFillBytesEditor = new IntegerEditor(0, 16);
        tc.setCellEditor((TableCellEditor)additionalFillBytesEditor);
        tc = tcm.getColumn(6);
        IntegerEditor additionalTotalBytesEditor = new IntegerEditor(0, 4096);
        tc.setCellEditor((TableCellEditor)additionalTotalBytesEditor);
        tc = tcm.getColumn(7);
        IntegerEditor identityProcessingWaitDuration = new IntegerEditor(0, 4096);
        tc.setCellEditor((TableCellEditor)identityProcessingWaitDuration);
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)pingTable));
        pingTable.getModel().addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + pingTable.getEmptyTableText() + ":f:gray}")));
        this.contentPanel.add((Component)overlayTable, "Center");
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_PING_TABLE_VIEW;
    }

    public Component getComponent() {
        return this.contentPanel;
    }
}

