/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.view;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.pt.model.PtProgrammerModel;
import org.bidib.wizard.mvc.pt.model.listener.ConfigVariableListener;
import org.bidib.wizard.mvc.pt.view.PtProgrammerView;
import org.bidib.wizard.mvc.pt.view.listener.PtProgrammerViewListener;
import org.bidib.wizard.mvc.pt.view.panel.AddressPanel;
import org.bidib.wizard.mvc.pt.view.panel.DirectAccessPanel;
import org.bidib.wizard.mvc.pt.view.panel.RailcomPanel;
import org.bidib.wizard.mvc.pt.view.panel.listener.PtRequestListener;
import org.bidib.wizard.mvc.pt.view.panel.listener.PtResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtProgrammerView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PtProgrammerView.class);
    private final DockKey DOCKKEY = new DockKey("PtProgrammerView");
    private final Collection<PtProgrammerViewListener> listeners = new LinkedList();
    private final PtProgrammerModel cvProgrammerModel;
    private Timer switchToProgramModeController;
    private final JButton closeButton = new JButton(Resources.getString(this.getClass(), (String)"close"));
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "p, 3dlu";
    private DirectAccessPanel directAccessPanel;
    private AddressPanel addressPanel;
    private RailcomPanel railcomPanel;
    private List<PtResultListener> ptResultListeners = new LinkedList();
    private final JTabbedPane tabbedPane;
    private final JPanel contentPanel;
    private JDialog dialog;
    private boolean switchToProgModeAfterSwitchCommandStationOn;

    public PtProgrammerView(PtProgrammerModel ptProgrammerModel) {
        this.cvProgrammerModel = ptProgrammerModel;
        this.DOCKKEY.setName(Resources.getString(this.getClass(), (String)"title"));
        this.DOCKKEY.setFloatEnabled(true);
        this.DOCKKEY.setAutoHideEnabled(false);
        this.tabbedPane = new JTabbedPane();
        1 ptRequestListener = new /* Unavailable Anonymous Inner Class!! */;
        this.directAccessPanel = new DirectAccessPanel(this.cvProgrammerModel);
        this.directAccessPanel.addPtRequestListener((PtRequestListener)ptRequestListener);
        this.ptResultListeners.add(this.directAccessPanel);
        this.addressPanel = new AddressPanel(this.cvProgrammerModel);
        this.addressPanel.addPtRequestListener((PtRequestListener)ptRequestListener);
        this.ptResultListeners.add(this.addressPanel);
        this.railcomPanel = new RailcomPanel(this.cvProgrammerModel);
        this.railcomPanel.addPtRequestListener((PtRequestListener)ptRequestListener);
        this.ptResultListeners.add(this.railcomPanel);
        this.closeButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton((JComponent)this.closeButton).build();
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            FormDebugPanel panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            JPanel panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel(panel);
        }
        dialogBuilder.border((Border)Paddings.DIALOG);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-address"), null, this.addressPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-address.tooltip"));
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-railcom"), null, this.railcomPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-railcom.tooltip"));
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-direct-access"), null, this.directAccessPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-direct-access.tooltip"));
        this.tabbedPane.setMnemonicAt(2, 51);
        dialogBuilder.appendRows("fill:p:grow", new Object[0]);
        dialogBuilder.add((Component)this.tabbedPane).xyw(1, 1, 3);
        dialogBuilder.appendRows("3dlu", new Object[0]);
        dialogBuilder.add((Component)buttons).xyw(1, 3, 3);
        this.contentPanel = dialogBuilder.build();
        DisabledPanel.disable((Container)this.contentPanel);
        this.closeButton.setEnabled(true);
        this.cvProgrammerModel.addConfigVariableListener((ConfigVariableListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    public void prepareDockable(DockingDesktop desktop, int x, int y) {
        desktop.addDockable((Dockable)this);
        this.initialize();
    }

    public void showDialog(JFrame parent, int x, int y) {
        this.dialog = new JDialog((Frame)parent, false);
        this.dialog.setTitle(Resources.getString(this.getClass(), (String)"title"));
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setContentPane(this.contentPanel);
        this.dialog.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.pack();
        this.dialog.setMinimumSize(new Dimension((int)this.contentPanel.getPreferredSize().getWidth() + 10, (int)this.contentPanel.getPreferredSize().getHeight() + 35));
        this.dialog.setLocation(x, y);
        this.dialog.setVisible(true);
        this.initialize();
    }

    public void initialize() {
        LOGGER.info("Switch CS to Programming mode.");
        this.switchToProgramModeController = new Timer(2000, (ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.switchToProgramModeController.setRepeats(false);
        this.switchToProgramModeController.start();
        CommandStationStatus commandStationState = this.fireGetCurrentCommandStationState();
        if (CommandStationStatus.isOffState((CommandStationStatus)commandStationState)) {
            LOGGER.info("Command station state is: {}. Set the command station to ON state before switch to prog mode.", (Object)commandStationState);
            this.switchToProgramModeController.start();
            this.switchToProgModeAfterSwitchCommandStationOn = true;
            this.addLogText("Switch command station ON.", new Object[0]);
            this.fireSetProgrammingMode(false);
        } else {
            this.switchToProgramModeController.start();
            LOGGER.info("Switch the command station to programming mode.");
            this.addLogText("Switch to programming mode.", new Object[0]);
            this.fireSetProgrammingMode(true);
        }
    }

    public void addPtProgrammerViewListener(PtProgrammerViewListener l) {
        this.listeners.add(l);
    }

    private void addLogText(String logLine, Object ... args) {
        for (PtResultListener listener : this.ptResultListeners) {
            listener.addLogText(logLine, args);
        }
    }

    private void signalCommandStationStateChanged(CommandStationState commandStationState) {
        if (CommandStationState.PROG.equals((Object)commandStationState)) {
            if (this.switchToProgramModeController != null) {
                LOGGER.info("The command station has switched to programming mode. Stop the control timer.");
                this.switchToProgramModeController.stop();
                this.switchToProgramModeController = null;
                this.addLogText("Switched to programming mode passed.", new Object[0]);
                DisabledPanel.enable((Container)this.contentPanel);
            } else {
                LOGGER.info("No control timer available.");
            }
        } else if (this.switchToProgModeAfterSwitchCommandStationOn) {
            this.switchToProgModeAfterSwitchCommandStationOn = false;
            if (this.switchToProgramModeController != null) {
                LOGGER.info("The command station has switched to ON mode. Restart the control timer.");
                this.switchToProgramModeController.restart();
                this.addLogText("Switch to programming mode.", new Object[0]);
                this.fireSetProgrammingMode(true);
            }
        }
    }

    private void signalCommandStationProgStateChanged(CommandStationProgState commandStationProgState) {
        if (commandStationProgState != null) {
            switch (6.$SwitchMap$org$bidib$jbidibc$messages$enums$CommandStationProgState[commandStationProgState.ordinal()]) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    LOGGER.info("Enable the tabs");
                    for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
                        this.tabbedPane.setEnabledAt(index, true);
                    }
                }
            }
        }
        for (PtResultListener listener : this.ptResultListeners) {
            listener.signalCommandStationProgStateChanged(commandStationProgState);
        }
    }

    public void close() {
        this.contentPanel.setVisible(false);
        if (this.switchToProgramModeController != null) {
            LOGGER.info("The command station has switched to programming mode. Stop the control timer.");
            this.switchToProgramModeController.stop();
            this.switchToProgramModeController = null;
        }
        if (this.dialog != null) {
            LOGGER.info("Terminate the programming mode!");
            try {
                this.fireSetProgrammingMode(false);
            }
            catch (Exception ex) {
                LOGGER.warn("Switch CommandStation to leave ProgrammMode failed!", (Throwable)ex);
                JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(PtProgrammerView.class, (String)"switch-off-prog-mode-failed.message"), Resources.getString(PtProgrammerView.class, (String)"switch-off-prog-mode-failed.title"), 0);
            }
            LOGGER.info("Close the dialog.");
            this.fireClose();
            this.dialog.dispose();
            this.dialog = null;
        } else {
            LOGGER.info("The dialog is closed already, skip set programming mode to false and fire close.");
        }
    }

    private void fireClose() {
        for (PtProgrammerViewListener l : this.listeners) {
            l.close();
        }
    }

    private void fireSetProgrammingMode(boolean activateProgMode) {
        for (PtProgrammerViewListener l : this.listeners) {
            l.sendCommandStationStateRequest(activateProgMode);
        }
    }

    private CommandStationStatus fireGetCurrentCommandStationState() {
        Iterator iterator = this.listeners.iterator();
        if (iterator.hasNext()) {
            PtProgrammerViewListener l = (PtProgrammerViewListener)iterator.next();
            return l.getCurrentCommandStationState();
        }
        return null;
    }
}

