package org.bidib.wizard.mvc.locolist.view.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JButton;
import javax.swing.SwingUtilities;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.locolist.model.LocoLibraryModel;
import org.bidib.wizard.mvc.locolist.model.LocoLibraryModel.ExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.dialog.ButtonEvent;
import com.jidesoft.dialog.ButtonNames;
import com.jidesoft.dialog.PageEvent;
import com.jidesoft.dialog.PageListener;
import com.jidesoft.wizard.CompletionWizardPage;

public class CompletionPage extends CompletionWizardPage {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionPage.class);

    private final LocoLibraryModel locoLibrary;

    private String executionStatus;

    public CompletionPage(final LocoLibraryModel locoLibrary) {
        super(Resources.getString(CompletionPage.class, "title"),
            Resources.getString(CompletionPage.class, "description.waiting"));

        this.locoLibrary = locoLibrary;

        executionStatus = Resources.getString(CompletionPage.class, "result.pending");

        locoLibrary.addPropertyChangeListener(LocoLibraryModel.PROPERTY_EXECUTION_STATUS, new PropertyChangeListener() {

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                LOGGER.info("The execution status has changed: {}", evt.getNewValue());
                SwingUtilities.invokeLater(() -> {
                    executionStatus = evt.getNewValue().toString();

                    reset();
                    repaint();
                });
            }
        });

        locoLibrary.addPropertyChangeListener(LocoLibraryModel.PROPERTY_PUSH_TO_MOUSE, new PropertyChangeListener() {
            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                boolean isPushToMouse = locoLibrary.isPushToMouse();
                if (!isPushToMouse) {

                    SwingUtilities.invokeLater(() -> {
                        // enable the finish button
                        LOGGER.info("Enable the finish button");
                        fireButtonEvent(ButtonEvent.ENABLE_BUTTON, ButtonNames.FINISH);

                        LOGGER.info("Enable the back button");
                        fireButtonEvent(ButtonEvent.ENABLE_BUTTON, ButtonNames.BACK);
                    });
                }
            }
        });

        addPageListener(new PageListener() {

            @Override
            public void pageEventFired(PageEvent e) {

                switch (e.getID()) {
                    case PageEvent.PAGE_OPENED:
                        LOGGER.info("Page was opened.");
                        executionStatus = Resources.getString(CompletionPage.class, "result.pending");
                        reset();
                        break;
                    case PageEvent.PAGE_CLOSING:
                        if (e.getSource() instanceof JButton) {
                            JButton button = (JButton) e.getSource();
                            if (ButtonNames.BACK.equals(button.getName())) {
                                LOGGER.info("The back button was pressed, reset the execution status.");

                                executionStatus = Resources.getString(CompletionPage.class, "result.pending");
                                locoLibrary.setExecutionResult(ExecutionResult.PENDING);
                            }
                        }
                        break;
                    default:
                        break;
                }
            }
        });

    }

    @Override
    protected void initContentPane() {
        LOGGER.info("Init the content pane was called.");
        super.initContentPane();

        updatePageLabels();
    }

    private void updatePageLabels() {
        LOGGER.info("Update the page labels.");

        switch (locoLibrary.getExecutionResult()) {
            case FAILED:
                addWarning(Resources.getString(CompletionPage.class, "result.failed"));
                break;
            case PASSED:
                addInfo(Resources.getString(CompletionPage.class, "result.passed"));
                break;
            default:
                addInfo(executionStatus);
                break;
        }
    }

    @Override
    public void setupWizardButtons() {
        LOGGER.info("Setup the wizard buttons.");
        super.setupWizardButtons();

        LOGGER.info("Disable the finish button");
        fireButtonEvent(ButtonEvent.DISABLE_BUTTON, ButtonNames.FINISH);

        LOGGER.info("Disable the back button");
        fireButtonEvent(ButtonEvent.DISABLE_BUTTON, ButtonNames.BACK);
    }
}
