package org.bidib.wizard.mvc.main.view.table;

import java.awt.event.MouseEvent;

import javax.swing.table.TableColumn;

import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.BidibStatusTableRenderer;
import org.bidib.wizard.client.common.view.renderer.PortConfigErrorAwareRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.mvc.main.model.MotorPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.MotorPortListPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.grid.TableColumnChooser;

import io.reactivex.rxjava3.subjects.Subject;

public class MotorPortTable extends AbstractPortHierarchicalTable<MotorPort> {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(MotorPortTable.class);

    private final MotorPortTableModel motorPortTableModel;

    public MotorPortTable(final MotorPortTableModel motorPortTableModel, String emptyTableText) {
        super(motorPortTableModel, emptyTableText);

        this.motorPortTableModel = motorPortTableModel;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = null;
        java.awt.Point p = e.getPoint();
        int rowIndex = rowAtPoint(p);
        int colIndex = columnAtPoint(p);

        if (rowIndex == -1 || colIndex == -1) {
            return tip;
        }

        int realColumnIndex = convertColumnIndexToModel(colIndex);

        if (realColumnIndex == MotorPortTableModel.COLUMN_VALUE) {

            MotorPort port = (MotorPort) getModel().getValueAt(rowIndex, MotorPortTableModel.COLUMN_PORT_INSTANCE);
            if (port.isEnabled()) {
                tip = prepareTooltip(port, port.getValue());
            }
            else {
                tip = super.getToolTipText();
            }

        }
        else {
            tip = super.getToolTipText();
        }
        return tip;
    }

    private String prepareTooltip(MotorPort port, int value) {
        LOGGER.trace("Set the new value: {}", value);

        StringBuilder tip = new StringBuilder(Resources.getString(MotorPortListPanel.class, "absolutevalue"));
        // tip.append(" ").append(targetAbsolute);
        // tip.append(", relative value: ");
        tip.append(value);
        return tip.toString();
    }

    @Override
    public void clearTable() {
        LOGGER.debug("clearTable, remove all rows and remove all slider editors");
    }

    @Override
    protected MotorPortEditorPanel createPortEditorPanel(
        final MotorPort port, int row, final Subject<PortConfigChangeEvent> portConfigChangeEventSubject,
        final NodeSelectionProvider nodeSelectionProvider) {

        // the port is the original port from the node

        MotorPortEditorPanel editorPanel =
            new MotorPortEditorPanel(port, motorPort -> this.motorPortTableModel.updatePortConfig(motorPort),
                motorPort -> this.motorPortTableModel.fireTestButtonPressed(motorPort),
                motorPort -> this.motorPortTableModel
                    .refreshRow(motorPort,
                        changedRow -> repaint(getCellRect(changedRow, MotorPortTableModel.COLUMN_LABEL, true))),
                portConfigChangeEventSubject, nodeSelectionProvider);
        editorPanel.createComponent();

        return editorPanel;
    }

    @Override
    public void prepareTableColumns() {

        TableColumn tc = getColumnModel().getColumn(MotorPortTableModel.COLUMN_LABEL);
        tc.setCellRenderer(new PortConfigErrorAwareRenderer(MotorPortTableModel.COLUMN_LABEL));
        tc.setIdentifier(Integer.valueOf(MotorPortTableModel.COLUMN_LABEL));

        // Set the status renderer
        tc = getColumnModel().getColumn(MotorPortTableModel.COLUMN_STATUS);
        tc.setIdentifier(Integer.valueOf(MotorPortTableModel.COLUMN_STATUS));
        tc
            .setCellRenderer(new BidibStatusTableRenderer(MotorPortStatus.class, "status.",
                MotorPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.MOTORPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        tc.setMinWidth(100);
        tc.setMaxWidth(120);

        final TableColumn buttonColumn = getColumnModel().getColumn(MotorPortTableModel.COLUMN_TEST);
        buttonColumn.setIdentifier(Integer.valueOf(MotorPortTableModel.COLUMN_TEST));
        buttonColumn.setMinWidth(180);
        buttonColumn.setMaxWidth(200);

        final PortComboBoxWithButtonEditorRenderer<BidibStatus> editor =
            new PortComboBoxWithButtonEditorRenderer<BidibStatus>(getActions(MotorPortStatus.FORWARD), ">",
                MotorPortStatus.class, MotorPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.MOTORPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            };
        // editor.addButtonListener(new ButtonListener() {
        //
        // @Override
        // public void buttonPressed(int row, int column, Object value) {
        // LOGGER.info("The test button was pressed, row: {}, column: {}", row, column);
        // getModel().setValueAt(value, row, MotorPortTableModel.COLUMN_TEST);
        // }
        // });

        buttonColumn.setCellEditor(editor);
        buttonColumn.setCellRenderer(editor);

        TableColumnChooser.hideColumn(this, MotorPortTableModel.COLUMN_PORT_INSTANCE);

    }
}
