/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.controller.CvDefinitionPanelControllerInterface;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.common.script.node.types.CvType;
import org.bidib.wizard.common.script.node.types.FeatureType;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.mvc.common.exception.NodeSelectionChangeException;
import org.bidib.wizard.mvc.main.controller.DefaultNodeScripting;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.nodescript.client.view.listener.NodeTreeScriptingListener;
import org.bidib.wizard.nodescript.script.node.ChangeLabelSupport;
import org.bidib.wizard.nodescript.script.node.NodeScriptingSupportProvider;
import org.bidib.wizard.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeScripting
implements NodeScripting {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultNodeScripting.class);
    private final MainModel mainModel;
    private final MainControllerInterface mainController;
    private final CvDefinitionPanelControllerInterface cvDefinitionPanelController;
    private final SwitchingNodeService switchingNodeService;
    private final NodeService nodeService;
    private final NodeScriptingSupportProvider nodeScriptingSupportProvider;

    public DefaultNodeScripting(MainModel mainModel, MainControllerInterface mainController, CvDefinitionPanelControllerInterface cvDefinitionPanelController, SwitchingNodeService switchingNodeService, NodeService nodeService, NodeScriptingSupportProvider nodeScriptingSupportProvider) {
        this.mainModel = mainModel;
        this.mainController = mainController;
        this.cvDefinitionPanelController = cvDefinitionPanelController;
        this.switchingNodeService = switchingNodeService;
        this.nodeService = nodeService;
        this.nodeScriptingSupportProvider = nodeScriptingSupportProvider;
    }

    public void setLabel(Long uuid, TargetType portType) {
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uuid.longValue()) {
            LOGGER.warn("Set CV can only be performed on the selected node!");
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            LOGGER.info("Change the label on the selected node.");
            this.setLabelInternal(uuid, portType);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    LOGGER.info("Change the label on the selected node, uuid: {}, portType: {}", (Object)uuid, (Object)portType);
                    this.setLabelInternal(uuid, portType);
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                LOGGER.warn("Change label failed.", (Throwable)ex);
            }
        }
    }

    private void setLabelInternal(Long uuid, TargetType targetType) {
        LOGGER.info("Set label, uuid: {}, targetType: {}", (Object)uuid, (Object)targetType);
        ChangeLabelSupport changeLabelSupport = this.nodeScriptingSupportProvider.lookup(targetType.getScriptingTargetType());
        if (changeLabelSupport != null) {
            changeLabelSupport.changeLabel(targetType);
        } else {
            LOGGER.warn("No changeLabelSupport available for targetType: {}", (Object)targetType);
        }
    }

    public void setCv(Long uuid, CvType ... cvTypes) {
        LOGGER.info("Set the CV, uuid: {}, cvTypes: {}", (Object)uuid, (Object)cvTypes);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uuid.longValue()) {
            LOGGER.warn("Set CV can only be performed on the selected node!");
            return;
        }
        LinkedList<ConfigurationVariable> cvList = new LinkedList<ConfigurationVariable>();
        for (CvType cvType : cvTypes) {
            cvList.add(new ConfigurationVariable(cvType.getCvNumber(), cvType.getCvValue()));
        }
        selectedNode.setConfigVariables(cvList);
        List configVars = this.cvDefinitionPanelController.setConfigVariables(selectedNode, cvList);
        selectedNode.updateConfigVariableValues(configVars, false);
    }

    public List<ConfigurationVariable> getCv(Long uniqueId, CvType ... cvTypes) {
        LOGGER.info("Get the CV directly from the node, uniqueId: {}, cvTypes: {}", (Object)uniqueId, (Object)cvTypes);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uniqueId.longValue()) {
            LOGGER.warn("Get CV can only be performed on the selected node!");
            return Collections.emptyList();
        }
        LinkedList<ConfigurationVariable> cvList = new LinkedList<ConfigurationVariable>();
        for (CvType cvType : cvTypes) {
            cvList.add(new ConfigurationVariable(cvType.getCvNumber(), cvType.getCvValue()));
        }
        List configVars = this.cvDefinitionPanelController.setConfigVariables(selectedNode, cvList);
        selectedNode.updateConfigVariableValues(configVars, true);
        return configVars;
    }

    public void setFeature(Long uuid, FeatureType ... featureTypes) {
        LOGGER.info("Set the feature, uuid: {}, featureTypes: {}", (Object)uuid, (Object)featureTypes);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uuid.longValue()) {
            LOGGER.warn("Set features can only be performed on the selected node!");
            return;
        }
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (FeatureType featureType : featureTypes) {
            features.add(new Feature(featureType.getFeatureNumber(), featureType.getFeatureValue()));
        }
        this.nodeService.setFeatures("main", selectedNode, features);
    }

    public List<Feature> featuresGetAll(Long uniqueId, boolean discardCache) {
        LOGGER.info("Get all features directly from the node, uniqueId: {}, discardCache: {}", (Object)uniqueId, (Object)discardCache);
        NodeInterface node = this.nodeService.getNode("main", uniqueId.longValue());
        if (node != null && node.getUniqueId() != uniqueId.longValue()) {
            LOGGER.warn("Get all features can only be performed on an available node!");
            return Collections.emptyList();
        }
        return this.nodeService.queryAllFeatures("main", node, discardCache);
    }

    public boolean isNodeHasRestartPending(Long uuid) {
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() == uuid.longValue()) {
            return selectedNode.isNodeHasRestartPendingError();
        }
        return false;
    }

    public void resetNode(Long uuid) {
        LOGGER.info("Reset node with uuid: {}", (Object)uuid);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uuid.longValue()) {
            LOGGER.warn("Reset node can only be performed on the selected node!");
            return;
        }
        this.mainController.resetNode(selectedNode);
    }

    public void reselectNode(Long uuid) {
        LOGGER.info("Reselect node with uuid: {}", (Object)uuid);
        NodeInterface node = NodeUtils.findNodeByUuid((Iterable)this.mainModel.getNodeProvider().getNodes(), (long)uuid);
        if (node != null) {
            LOGGER.info("Set the selected node in the mainModel: {}", (Object)node);
            NodeTreeScriptingListener nodeListPanel = (NodeTreeScriptingListener)DefaultApplicationContext.getInstance().get("nodeListPanel", NodeTreeScriptingListener.class);
            if (nodeListPanel != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    try {
                        LOGGER.info("Change the selected node.");
                        nodeListPanel.setSelectedNode(node);
                    }
                    catch (IllegalArgumentException | NodeSelectionChangeException ex) {
                        LOGGER.warn("Select node failed.", ex);
                        throw ex;
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        try {
                            LOGGER.info("Change the selected node.");
                            nodeListPanel.setSelectedNode(node);
                        }
                        catch (IllegalArgumentException | NodeSelectionChangeException ex) {
                            LOGGER.warn("Select node failed.", ex);
                            throw ex;
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    LOGGER.warn("Select node failed.", (Throwable)ex);
                }
            }
        }
    }

    public void setAccessory(Long uuid, Accessory accessory) {
        LOGGER.info("Set the accessory, uuid: {}, accessory: {}", (Object)uuid, (Object)accessory);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uuid.longValue()) {
            LOGGER.warn("Set accessory can only be performed on the selected node!");
            return;
        }
        LOGGER.info("Transfer accessory to node: {}", (Object)accessory);
        this.mainController.transferAccessoryToNode(selectedNode, accessory);
    }

    public void setMacro(Long uuid, Macro macro) {
        LOGGER.info("Set the macro, uuid: {}, macro: {}", (Object)uuid, (Object)macro);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uuid.longValue()) {
            LOGGER.warn("Set macro can only be performed on the selected node!");
            return;
        }
        LOGGER.info("Transfer the macro to node and save permanently, node: {}, macro: {}", (Object)selectedNode, (Object)macro);
        try {
            this.switchingNodeService.saveMacro(this.mainModel.getConnectionId(), selectedNode.getSwitchingNode(), macro);
        }
        catch (NoAnswerException ex) {
            LOGGER.warn("Transfer macro and save macro failed.", (Throwable)ex);
            selectedNode.setNodeHasError(true);
            selectedNode.setReasonData("Transfer macro and save macro failed.");
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Transfer macro and save macro failed.", (Throwable)ex);
            selectedNode.setNodeHasError(true);
            selectedNode.setReasonData("Transfer macro and save macro failed.");
        }
    }

    public void setPortConfig(Long uuid, TargetType portType, Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER.info("Set the port config, uuid: {}, portConfig: {}", (Object)uuid, portConfig);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uuid.longValue()) {
            LOGGER.warn("Set port config can only be performed on the selected node!");
            return;
        }
        if (selectedNode != null) {
            switch (1.$SwitchMap$org$bidib$wizard$common$script$node$types$ScriptingTargetType[portType.getScriptingTargetType().ordinal()]) {
                case 1: {
                    selectedNode.setAnalogPortConfig(portType.getPortNum().intValue(), portConfig);
                    break;
                }
                case 2: {
                    selectedNode.setBacklightPortConfig(portType.getPortNum().intValue(), portConfig);
                    break;
                }
                case 3: {
                    selectedNode.setLightPortConfig(portType.getPortNum().intValue(), portConfig);
                    break;
                }
                case 4: {
                    selectedNode.setServoPortConfig(portType.getPortNum().intValue(), portConfig);
                    break;
                }
                case 5: {
                    selectedNode.setSwitchPortConfig(portType.getPortNum().intValue(), portConfig);
                    break;
                }
                case 6: {
                    selectedNode.setSwitchPairPortConfig(portType.getPortNum().intValue(), portConfig);
                    break;
                }
                case 7: {
                    selectedNode.setSoundPortConfig(portType.getPortNum().intValue(), portConfig);
                    break;
                }
                default: {
                    LOGGER.error("Unsupported port type detected: {}", (Object)portType);
                }
            }
        }
        this.mainController.replacePortConfig(portType, portConfig);
    }

    public void assertPortType(Long uuid, TargetType portType) {
        LOGGER.info("Assert that the port type matches, uuid: {}, portType: {}", (Object)uuid, (Object)portType);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uuid.longValue()) {
            LOGGER.warn("Set port config can only be performed on the selected node!");
            return;
        }
        this.mainController.mapPortType(portType);
    }

    public void setIdentifyState(Long uniqueId, IdentifyState identifyState) {
        LOGGER.info("Set the identify state, uniqueId: {}, identifyState: {}", (Object)uniqueId, (Object)identifyState);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getUniqueId() != uniqueId.longValue()) {
            LOGGER.warn("Set identify state can only be performed on the selected node!");
            return;
        }
        selectedNode.setIdentifyState(identifyState);
    }

    public IdentifyState queryIdentifyState(Long uniqueId) {
        NodeInterface node = this.mainModel.getSelectedNode();
        return node.getIdentifyState();
    }

    public String setString(Long uniqueId, int namespace, int index, String value) {
        return null;
    }

    public String getString(Long uniqueId, int namespace, int index) {
        return null;
    }

    public String sendNodeDebugString(Long uniqueId, int namespace, int index, String value, int expectedResponseCount) {
        return null;
    }
}

