/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.util.Arrays;
import java.util.Set;
import java.util.function.IntConsumer;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.mvc.main.model.listener.MotorPortModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotorPortTableModel
extends SimpleHierarchicalPortTableModel<MotorPortStatus, MotorPort, MotorPortModelListener> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorPortTableModel.class);
    public static final int COLUMN_LABEL = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_TEST = 3;
    public static final int COLUMN_PORT_INSTANCE = 4;

    public int getColumnPortInstance() {
        return 4;
    }

    public Integer getTestColumnIndex() {
        return 3;
    }

    protected void initialize() {
        this.columnNames = new String[]{Resources.getString(MotorPortTableModel.class, (String)"label"), Resources.getString(MotorPortTableModel.class, (String)"value"), Resources.getString(MotorPortTableModel.class, (String)"status"), Resources.getString(MotorPortTableModel.class, (String)"test"), null};
    }

    public void addRow(MotorPort motorPort) {
        if (motorPort != null) {
            Object[] rowData = new Object[this.columnNames.length];
            rowData[0] = motorPort.getLabel();
            rowData[1] = motorPort.getValue();
            rowData[2] = motorPort.getStatus();
            MotorPortStatus oppositeStatus = (MotorPortStatus)PortUtils.getOppositeStatus((BidibStatus)((MotorPortStatus)motorPort.getStatus()));
            rowData[3] = oppositeStatus;
            rowData[4] = motorPort;
            this.addRow(rowData);
        } else {
            LOGGER.warn("Performed addRow without servo port instance.");
        }
    }

    public boolean isCellEditable(int row, int column) {
        boolean isEditable = false;
        MotorPort motorPort = (MotorPort)this.getValueAt(row, 4);
        switch (column) {
            case 3: {
                if (Port.getConfiguredPortType((Port)motorPort) != LcOutputType.MOTORPORT) break;
                isEditable = true;
                break;
            }
        }
        return isEditable;
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
        }
        return Integer.class;
    }

    public void setValueAt(Object value, int row, int column) {
        MotorPort port = (MotorPort)this.getValueAt(row, 4);
        switch (column) {
            case 0: {
                port.setLabel((String)value);
                super.setValueAt((Object)port.toString(), row, column);
                this.fireLabelChanged((Port)port, port.getLabel());
                break;
            }
            case 2: {
                port.setStatus((BidibStatus)((MotorPortStatus)value));
                super.setValueAt(value, row, column);
                break;
            }
            case 1: {
                int intValue = (Integer)value;
                LOGGER.info("Set the value, new value: {}, port.value: {}", value, (Object)port.getValue());
                port.setValue(Integer.valueOf(intValue));
                super.setValueAt((Object)intValue, row, column);
                MotorPort motorPort = new MotorPort();
                motorPort.setId(port.getId());
                motorPort.setValue(Integer.valueOf(intValue));
                this.fireTestButtonPressed(motorPort);
            }
        }
    }

    public Object getValueAt(int row, int column) {
        MotorPort port = (MotorPort)super.getValueAt(row, 4);
        switch (column) {
            case 0: {
                column = 4;
                break;
            }
            case 2: {
                return port.getStatus();
            }
            case 1: {
                Integer portValue = port.getValue();
                LOGGER.trace("Get the port value: {}, row: {}", (Object)portValue, (Object)row);
                return portValue;
            }
            default: {
                column = 4;
            }
        }
        return super.getValueAt(row, column);
    }

    public void notifyPortStatusChanged(MotorPort port) {
        LOGGER.info("Update the port status: {}", (Object)port);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 4))) continue;
            LOGGER.info("The port state has changed: {}", (Object)port.getStatus());
            super.setValueAt((Object)port.getStatus(), row, 2);
            MotorPortStatus oppositeStatus = (MotorPortStatus)PortUtils.getOppositeStatus((BidibStatus)((MotorPortStatus)port.getStatus()));
            LOGGER.info("Set the opposite state: {}", (Object)oppositeStatus);
            super.setValueAt((Object)oppositeStatus, row, 3);
            break;
        }
    }

    public void notifyPortConfigChanged(MotorPort port) {
        LOGGER.debug("The port config was changed for port: {}", (Object)port);
        this.notifyPortStatusChanged(port);
    }

    public void notifyPortLabelChanged(MotorPort port) {
        LOGGER.info("The port label was changed for port: {}", (Object)port.getDebugString());
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 4))) continue;
            super.setValueAt((Object)port.toString(), row, 0);
            break;
        }
    }

    public void refreshRow(MotorPort port, IntConsumer rowConsumer) {
        int row = this.findRow(port);
        rowConsumer.accept(row);
    }

    private int findRow(MotorPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            MotorPort current = (MotorPort)this.getValueAt(row, 4);
            if (!port.equals((Object)current)) continue;
            return row;
        }
        return -1;
    }

    public void updatePortConfig(MotorPort port) {
        LOGGER.debug("The config of the port has changed: {}", (Object)port.getDebugString());
        PortConfigKeys[] keys = PortConfigKeys.valueOf((Set)port.getKnownPortConfigKeys());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("prepared keys: {}", Arrays.asList(keys));
        }
        this.fireConfigValuesChanged(port, keys);
        int row = this.findRow(port);
        if (row > -1) {
            this.setValueAt((Object)port.getLabel(), row, 0);
        }
    }

    private void fireConfigValuesChanged(MotorPort port, PortConfigKeys ... portConfigKeys) {
        LOGGER.info("The values of the port have changed: {}", (Object)port);
        ((MotorPortModelListener)this.portListener).configChanged((Port)port, portConfigKeys);
    }

    public void changePortType(LcOutputType portType, Port<? extends BidibStatus> port) {
        ((MotorPortModelListener)this.portListener).changePortType(portType, port);
    }

    protected MotorPort getRow(int rowIndex) {
        MotorPort motorPort = (MotorPort)this.getValueAt(rowIndex, 4);
        return motorPort;
    }

    public void fireTestButtonPressed(MotorPort port) {
        LOGGER.info("The value has changed for port: {}", (Object)port);
        ((MotorPortModelListener)this.portListener).testButtonPressed(port, (MotorPortStatus)port.getStatus());
    }
}

