/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.util.Arrays;
import java.util.Set;
import java.util.function.IntConsumer;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.model.listener.SoundPortModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundPortTableModel
extends SimpleHierarchicalPortTableModel<SoundPortStatus, SoundPort, SoundPortModelListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundPortTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_LABEL = 0;
    public static final int COLUMN_PULSE_TIME = 1;
    public static final int COLUMN_PORT_IDENTIFIER = 2;
    public static final int COLUMN_STATUS = 3;
    public static final int COLUMN_TEST = 4;
    public static final int COLUMN_PORT_INSTANCE = 5;

    public int getColumnPortInstance() {
        return 5;
    }

    public Integer getTestColumnIndex() {
        return 4;
    }

    protected void initialize() {
        this.columnNames = new String[]{Resources.getString(this.getClass(), (String)"label"), Resources.getString(this.getClass(), (String)"pulseTime"), Resources.getString(this.getClass(), (String)"portIdentifier"), Resources.getString(this.getClass(), (String)"status"), Resources.getString(this.getClass(), (String)"test"), null};
    }

    public void addRow(SoundPort port) {
        if (port != null) {
            Object[] rowData = new Object[this.columnNames.length];
            rowData[0] = port.getLabel();
            rowData[1] = port.getPulseTime();
            rowData[2] = port.getPortIdentifier();
            rowData[3] = port.getStatus();
            SoundPortStatus oppositeStatus = (SoundPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SoundPortStatus)port.getStatus()));
            rowData[4] = oppositeStatus;
            rowData[5] = port;
            this.addRow(rowData);
        }
    }

    public boolean isCellEditable(int row, int column) {
        boolean isEditable = false;
        SoundPort soundPort = (SoundPort)this.getValueAt(row, 5);
        switch (column) {
            case 0: {
                isEditable = true;
                break;
            }
            case 1: {
                if (!soundPort.isEnabled() || !soundPort.isPortConfigKeySupported(Byte.valueOf((byte)11))) break;
                isEditable = true;
                break;
            }
            case 3: {
                isEditable = false;
            }
            case 4: {
                if (!soundPort.isEnabled()) break;
                isEditable = true;
                break;
            }
        }
        return isEditable;
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 2: 
            case 5: {
                return Object.class;
            }
            case 3: {
                return Object.class;
            }
            case 4: {
                return Object.class;
            }
        }
        return Object.class;
    }

    public void setValueAt(Object value, int row, int column) {
        Object o = this.getValueAt(row, 5);
        if (o instanceof SoundPort) {
            SoundPort port = (SoundPort)o;
            switch (column) {
                case 0: {
                    port.setLabel((String)value);
                    super.setValueAt((Object)port.toString(), row, column);
                    this.fireLabelChanged((Port)port, port.getLabel());
                    break;
                }
                case 1: {
                    int pulseTime = (Integer)value;
                    if (port.getPulseTime() != pulseTime) {
                        port.setPulseTime(pulseTime);
                        super.setValueAt(value, row, column);
                        this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_TICKS});
                        break;
                    }
                    LOGGER.debug("The pulse time has not been changed.");
                    break;
                }
                case 3: {
                    port.setStatus((BidibStatus)((SoundPortStatus)value));
                    super.setValueAt(value, row, column);
                    break;
                }
                case 4: {
                    SoundPortStatus portStatus = (SoundPortStatus)value;
                    LOGGER.info("Set the test port status: {}", (Object)portStatus);
                    super.setValueAt((Object)portStatus, row, column);
                    SoundPort soundPort = new SoundPort();
                    soundPort.setId(port.getId());
                    soundPort.setStatus((BidibStatus)portStatus);
                    this.fireTestButtonPressed(soundPort);
                    break;
                }
                default: {
                    super.setValueAt(value, row, column);
                    break;
                }
            }
        } else {
            super.setValueAt(value, row, column);
        }
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                column = 5;
                break;
            }
        }
        return super.getValueAt(row, column);
    }

    public void notifyPortStatusChanged(SoundPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 5))) continue;
            LOGGER.debug("The port state has changed: {}", (Object)port.getStatus());
            super.setValueAt((Object)port.getStatus(), row, 3);
            SoundPortStatus oppositeStatus = (SoundPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SoundPortStatus)port.getStatus()));
            LOGGER.info("Set the port status, oppositeStatus: {}", (Object)oppositeStatus);
            this.setValueAt((Object)oppositeStatus, row, 4);
            break;
        }
    }

    public void notifyPortConfigChanged(SoundPort port) {
    }

    public void notifyPortLabelChanged(SoundPort port) {
        LOGGER.info("The port label was changed for port: {}", (Object)port);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 5))) continue;
            super.setValueAt((Object)port.toString(), row, 0);
            break;
        }
    }

    public void refreshRow(SoundPort port, IntConsumer rowConsumer) {
        int row = this.findRow(port);
        rowConsumer.accept(row);
    }

    private int findRow(SoundPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            SoundPort current = (SoundPort)this.getValueAt(row, 5);
            if (!port.equals((Object)current)) continue;
            return row;
        }
        return -1;
    }

    public void updatePortConfig(SoundPort port) {
        LOGGER.debug("The config of the port has changed: {}", (Object)port.getDebugString());
        PortConfigKeys[] keys = PortConfigKeys.valueOf((Set)port.getKnownPortConfigKeys());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("prepared keys: {}", Arrays.asList(keys));
        }
        this.fireConfigValuesChanged(port, keys);
        int row = this.findRow(port);
        if (row > -1) {
            this.setValueAt((Object)port.getLabel(), row, 0);
        }
    }

    private void fireConfigValuesChanged(SoundPort port, PortConfigKeys ... portConfigKeys) {
        LOGGER.info("The values of the port have changed: {}", (Object)port);
        ((SoundPortModelListener)this.portListener).configChanged((Port)port, portConfigKeys);
    }

    public void changePortType(LcOutputType portType, Port<? extends BidibStatus> port) {
        ((SoundPortModelListener)this.portListener).changePortType(portType, port);
    }

    protected SoundPort getRow(int rowIndex) {
        SoundPort port = (SoundPort)this.getValueAt(rowIndex, 5);
        return port;
    }

    public void fireTestButtonPressed(SoundPort port) {
        LOGGER.info("Port status has changed for port: {}", (Object)port);
        ((SoundPortModelListener)this.portListener).testButtonPressed(port, (SoundPortStatus)port.getStatus());
    }
}

