/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.util.Arrays;
import java.util.Set;
import java.util.function.IntConsumer;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.SwitchPairPortModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPairPortTableModel
extends SimpleHierarchicalPortTableModel<SwitchPortStatus, SwitchPairPort, SwitchPairPortModelListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPairPortTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_LABEL = 0;
    public static final int COLUMN_SWITCH_OFF_TIME = 1;
    public static final int COLUMN_LOAD_TYPE = 2;
    public static final int COLUMN_PORT_IDENTIFIER = 3;
    public static final int COLUMN_STATUS = 4;
    public static final int COLUMN_TEST = 5;
    public static final int COLUMN_PORT_INSTANCE = 6;

    public SwitchPairPortTableModel(MainModel model) {
    }

    public int getColumnPortInstance() {
        return 6;
    }

    public Integer getTestColumnIndex() {
        return 5;
    }

    protected void initialize() {
        this.columnNames = new String[]{Resources.getString(this.getClass(), (String)"label"), Resources.getString(this.getClass(), (String)"switchOffTime"), Resources.getString(this.getClass(), (String)"loadType"), Resources.getString(this.getClass(), (String)"portIdentifier"), Resources.getString(this.getClass(), (String)"status"), Resources.getString(this.getClass(), (String)"test"), null};
    }

    public void addRow(SwitchPairPort port) {
        if (port != null) {
            Object[] rowData = new Object[this.columnNames.length];
            rowData[0] = port.getLabel();
            rowData[1] = port.getSwitchOffTime();
            rowData[2] = port.getLoadType();
            rowData[3] = port.getPortIdentifier();
            rowData[4] = port.getStatus();
            SwitchPortStatus oppositeStatus = (SwitchPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SwitchPortStatus)port.getStatus()));
            rowData[5] = oppositeStatus;
            rowData[6] = port;
            this.addRow(rowData);
        }
    }

    public boolean isCellEditable(int row, int column) {
        boolean isEditable = false;
        SwitchPairPort switchPairPort = (SwitchPairPort)this.getValueAt(row, 6);
        switch (column) {
            case 5: {
                if (Port.getConfiguredPortType((Port)switchPairPort) != LcOutputType.SWITCHPAIRPORT) break;
                isEditable = true;
                break;
            }
        }
        return isEditable;
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 3: 
            case 6: {
                return Object.class;
            }
            case 2: {
                return LoadTypeEnum.class;
            }
            case 4: {
                return Object.class;
            }
            case 5: {
                return Object.class;
            }
        }
        return Object.class;
    }

    public void setValueAt(Object value, int row, int column) {
        SwitchPairPort port = (SwitchPairPort)this.getValueAt(row, 6);
        switch (column) {
            case 0: {
                port.setLabel((String)value);
                super.setValueAt((Object)port.toString(), row, column);
                this.fireLabelChanged((Port)port, port.getLabel());
                break;
            }
            case 1: {
                int switchOffTime = (Integer)value;
                if (port.getSwitchOffTime() != switchOffTime) {
                    port.setSwitchOffTime(Integer.valueOf(switchOffTime));
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_TICKS});
                    break;
                }
                LOGGER.debug("The switchOff time has not been changed.");
                break;
            }
            case 2: {
                LoadTypeEnum loadType = (LoadTypeEnum)value;
                if (loadType != port.getLoadType()) {
                    port.setLoadType(loadType);
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_LOAD_TYPE});
                    break;
                }
                LOGGER.debug("The load type has not been changed.");
                break;
            }
            case 4: {
                port.setStatus((BidibStatus)((SwitchPortStatus)value));
                super.setValueAt(value, row, column);
                break;
            }
            case 5: {
                LOGGER.info("Status of switch port is updated: {}, port: {}", value, (Object)port);
                SwitchPortStatus portStatus = (SwitchPortStatus)value;
                LOGGER.info("Set the test port status: {}", (Object)portStatus);
                super.setValueAt((Object)portStatus, row, column);
                SwitchPairPort switchPairPort = new SwitchPairPort();
                switchPairPort.setId(port.getId());
                switchPairPort.setStatus((BidibStatus)portStatus);
                this.fireTestButtonPressed(switchPairPort);
                break;
            }
            default: {
                super.setValueAt(value, row, column);
            }
        }
    }

    public Object getValueAt(int row, int column) {
        SwitchPairPort port = (SwitchPairPort)super.getValueAt(row, 6);
        switch (column) {
            case 0: 
            case 3: {
                column = 6;
                break;
            }
            case 2: {
                return port.getLoadType();
            }
            case 1: {
                return port.getSwitchOffTime();
            }
            case 4: {
                return port.getStatus();
            }
            case 6: {
                return port;
            }
        }
        return super.getValueAt(row, column);
    }

    public void notifyPortStatusChanged(SwitchPairPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 6))) continue;
            LOGGER.info("The port state has changed: {}", (Object)port.getStatus());
            super.setValueAt((Object)port.getStatus(), row, 4);
            SwitchPortStatus oppositeStatus = (SwitchPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SwitchPortStatus)port.getStatus()));
            LOGGER.info("Update port status: {}, oppositeStatus: {}", (Object)port.getStatus(), (Object)oppositeStatus);
            super.setValueAt((Object)oppositeStatus, row, 5);
            break;
        }
    }

    public void notifyPortConfigChanged(SwitchPairPort port) {
        LOGGER.debug("The port config was changed for port: {}", (Object)port);
        this.notifyPortStatusChanged(port);
    }

    public void notifyPortLabelChanged(SwitchPairPort port) {
        LOGGER.info("The port label was changed for port: {}", (Object)port);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 6))) continue;
            super.setValueAt((Object)port.toString(), row, 0);
            break;
        }
    }

    public void refreshRow(SwitchPairPort port, IntConsumer rowConsumer) {
        int row = this.findRow(port);
        rowConsumer.accept(row);
    }

    private int findRow(SwitchPairPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            SwitchPairPort current = (SwitchPairPort)this.getValueAt(row, 6);
            if (!port.equals((Object)current)) continue;
            return row;
        }
        return -1;
    }

    public void updatePortConfig(SwitchPairPort port) {
        LOGGER.debug("The config of the port has changed: {}", (Object)port.getDebugString());
        PortConfigKeys[] keys = PortConfigKeys.valueOf((Set)port.getKnownPortConfigKeys());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("prepared keys: {}", Arrays.asList(keys));
        }
        this.fireConfigValuesChanged(port, keys);
        int row = this.findRow(port);
        if (row > -1) {
            this.setValueAt((Object)port.getLabel(), row, 0);
        }
    }

    private void fireConfigValuesChanged(SwitchPairPort port, PortConfigKeys ... portConfigKeys) {
        LOGGER.info("The values of the port have changed: {}", (Object)port);
        ((SwitchPairPortModelListener)this.portListener).configChanged((Port)port, portConfigKeys);
    }

    public void changePortType(LcOutputType portType, Port<? extends BidibStatus> port) {
        ((SwitchPairPortModelListener)this.portListener).changePortType(portType, port);
    }

    protected SwitchPairPort getRow(int rowIndex) {
        SwitchPairPort port = (SwitchPairPort)this.getValueAt(rowIndex, 6);
        return port;
    }

    public void fireTestButtonPressed(SwitchPairPort port) {
        LOGGER.info("Port status has changed for port: {}", (Object)port);
        ((SwitchPairPortModelListener)this.portListener).testButtonPressed(port, (SwitchPortStatus)port.getStatus());
    }
}

