/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidibbase.BaseLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.exchange.vendorcv.VendorCV;
import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.AccessoryAspect;
import org.bidib.wizard.api.model.AccessoryAspectMacro;
import org.bidib.wizard.api.model.AccessoryAspectParam;
import org.bidib.wizard.api.model.AccessorySaveState;
import org.bidib.wizard.api.model.AccessorySwitchTimeModel;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.AccessoryExecutionListener;
import org.bidib.wizard.api.model.listener.AccessoryListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.table.AbstractStatusEmptyTable;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.validation.DefaultRangeValidationCallback;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.AccessoryLabelUtils;
import org.bidib.wizard.common.script.node.types.AccessoryAspectTargetType;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.stringdata.StoredStrings;
import org.bidib.wizard.mvc.accessory.view.panel.AbstractAccessoryPanel;
import org.bidib.wizard.mvc.common.view.table.DefaultTextCellEditor;
import org.bidib.wizard.mvc.main.controller.AccessoryPanelController;
import org.bidib.wizard.mvc.main.model.AccessoryStartupAspectModel;
import org.bidib.wizard.mvc.main.model.AccessoryTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SelectedAccessoryModel;
import org.bidib.wizard.mvc.main.model.listener.AccessoryPortListener;
import org.bidib.wizard.mvc.main.model.listener.AccessorySelectionListener;
import org.bidib.wizard.mvc.main.view.menu.AccessoryTableMenu;
import org.bidib.wizard.mvc.main.view.menu.listener.AccessoryTableMenuListener;
import org.bidib.wizard.mvc.main.view.panel.AccessoryPanel;
import org.bidib.wizard.mvc.main.view.panel.AspectTable;
import org.bidib.wizard.mvc.main.view.table.AccessoryAspectRenderer;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlControllerInterface;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryPanel
extends JPanel
implements AccessoryExecutionListener,
AccessoryListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryPanel.class);
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref";
    private final AbstractStatusEmptyTable aspectTable;
    private final AccessoryTableModel tableModel;
    private final AccessoryTableMenu accessoryTableMenu;
    private JLabel currentAspectLabel;
    private JLabel executionStateIconLabel;
    private ImageIcon accessoryErrorIcon;
    private ImageIcon accessorySuccessfulIcon;
    private ImageIcon accessoryWaitIcon;
    private ImageIcon accessoryUnknownIcon;
    private SelectionInList<AccessoryAspect> startupAspectSelection;
    private ValueModel selectionHolderStartupAspect;
    private final AccessoryStartupAspectModel accessoryStartupAspectModel;
    private final AccessorySwitchTimeModel accessorySwitchTimeModel;
    private final AccessoryPanelController accessoryPanelController;
    private final MainModel mainModel;
    private MacroRef[] macrosClipBoard;
    private final SelectedAccessoryModel selectedAccessoryModel;
    private final PropertyChangeListener labelChangedListener;
    private final ValueModel selectedAccessoryValueModel;
    private ValueModel switchTimeValueModel;
    private JLabel labelSwitchTime;
    private JTextField switchTimeText;
    private JComponent[] baseUnitButtons;
    private final PropertyChangeListener startupAspectChangeListener;
    private final PropertyChangeListener switchTimeChangeListener;
    private final JLabel labelInitialState;
    private final JComboBox<Accessory> comboStartupAspect;
    protected ValidationResultModel validationModel;
    private ValueModel saveButtonEnabledModel = new ValueHolder(false);
    private ArrayListModel<StepControlAspect> stepControlAspects;
    private ListDataListener stepControlAspectsListener;

    public AccessoryPanel(AccessoryPanelController accessoryPanelController, MainModel model, AccessoryStartupAspectModel accessoryStartupAspectModel, AccessorySwitchTimeModel accessorySwitchTimeModel) {
        this.mainModel = model;
        this.accessoryPanelController = accessoryPanelController;
        this.accessoryStartupAspectModel = accessoryStartupAspectModel;
        this.accessorySwitchTimeModel = accessorySwitchTimeModel;
        this.selectedAccessoryModel = new SelectedAccessoryModel();
        this.validationModel = new DefaultValidationResultModel();
        this.labelChangedListener = evt -> {
            LOGGER.info("The label has changed.");
            this.selectedAccessoryModel.triggerLabelChanged();
        };
        this.initialize();
        this.setLayout((LayoutManager)new BorderLayout());
        this.accessoryTableMenu = new AccessoryTableMenu(model);
        this.accessoryTableMenu.addMenuListener((AccessoryTableMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tableModel = new AccessoryTableModel(model);
        FormBuilder formBuilder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]);
        formBuilder.border(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.selectedAccessoryValueModel = new PropertyAdapter((Object)this.selectedAccessoryModel, "selectedAccessory", true);
        ConverterValueModel valueConverterModel = new ConverterValueModel(this.selectedAccessoryValueModel, (BindingConverter)new AccessoryConverter());
        JLabel selectedAccessoryLabel = WizardComponentFactory.createLabel((ValueModel)valueConverterModel);
        formBuilder.add(Resources.getString(this.getClass(), (String)"accessoryName"), new Object[0]).xy(1, 1);
        formBuilder.add((Component)selectedAccessoryLabel).xyw(3, 1, 5);
        this.startupAspectSelection = new SelectionInList((ListModel)accessoryStartupAspectModel.getAccessoryAspectList());
        this.selectionHolderStartupAspect = new PropertyAdapter((Object)accessoryStartupAspectModel, "selectedStartupAspect", true);
        ComboBoxAdapter comboBoxAdapterStartupAspect = new ComboBoxAdapter((ListModel)this.startupAspectSelection, this.selectionHolderStartupAspect);
        this.comboStartupAspect = new JComboBox();
        this.comboStartupAspect.setModel(comboBoxAdapterStartupAspect);
        ValidationComponentUtils.setMessageKey((JComponent)this.comboStartupAspect, (Object)"validation.startupAspect_key");
        this.labelInitialState = new JLabel(Resources.getString(this.getClass(), (String)"initialState"));
        formBuilder.add((Component)this.labelInitialState).xy(1, 3);
        formBuilder.add((Component)this.comboStartupAspect).xy(3, 3);
        this.switchTimeValueModel = new PropertyAdapter((Object)accessorySwitchTimeModel, "switchTime", true);
        ConverterValueModel switchTimeConverterModel = new ConverterValueModel(this.switchTimeValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.switchTimeText = new JTextField();
        IntegerInputValidationDocument switchTimeDocument = new IntegerInputValidationDocument(3, "0123456789");
        switchTimeDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, 127));
        this.switchTimeText.setDocument((Document)switchTimeDocument);
        this.switchTimeText.setColumns(3);
        Bindings.bind((JTextField)this.switchTimeText, (ValueModel)switchTimeConverterModel, (boolean)false);
        this.labelSwitchTime = new JLabel(Resources.getString(AbstractAccessoryPanel.class, (String)"switchTime"));
        formBuilder.add((Component)this.labelSwitchTime).xy(5, 3);
        formBuilder.add((Component)this.switchTimeText).xy(7, 3);
        ValidationComponentUtils.setMandatory((JComponent)this.switchTimeText, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.switchTimeText, (Object[])new Object[]{"validation.switchtime_key"});
        PropertyAdapter modeModel = new PropertyAdapter((Object)accessorySwitchTimeModel, "timeBaseUnit", true);
        this.baseUnitButtons = new JComponent[TimeBaseUnitEnum.values().length];
        int index = 0;
        int column = 9;
        for (TimeBaseUnitEnum timeBaseUnitEnum : TimeBaseUnitEnum.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)modeModel, (Object)timeBaseUnitEnum, (String)Resources.getString(TimeBaseUnitEnum.class, (String)timeBaseUnitEnum.getKey()));
            this.baseUnitButtons[index++] = radio;
            formBuilder.add((Component)radio).xy(column, 3);
            column += 2;
        }
        for (JComponent jComponent : this.baseUnitButtons) {
            jComponent.setEnabled(false);
        }
        this.switchTimeText.setEnabled(false);
        this.labelSwitchTime.setEnabled(false);
        this.labelInitialState.setEnabled(false);
        this.comboStartupAspect.setEnabled(false);
        this.startupAspectChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.accessoryStartupAspectModel.addPropertyChangeListener("selectedStartupAspect", this.startupAspectChangeListener);
        this.switchTimeChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.accessorySwitchTimeModel.addPropertyChangeListener(this.switchTimeChangeListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel executionStateTextLabel = new JLabel(Resources.getString(AccessoryPanel.class, (String)"execution_state"));
        executionStateTextLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        jPanel.add(executionStateTextLabel);
        this.executionStateIconLabel = new JLabel();
        jPanel.add(this.executionStateIconLabel);
        formBuilder.add((Component)jPanel).xyw(1, 5, 9);
        this.currentAspectLabel = new JLabel();
        jPanel.add(this.currentAspectLabel);
        formBuilder.add((Component)this.currentAspectLabel).xyw(11, 5, 3);
        this.aspectTable = new AspectTable(this.tableModel, Resources.getString(AccessoryPanel.class, (String)"emptyTable"), (NodeSelectionProvider)model);
        TableColumn tc = this.aspectTable.getColumnModel().getColumn(0);
        tc.setCellRenderer((TableCellRenderer)new AccessoryAspectRenderer(Resources.getString(AccessoryTableModel.class, (String)"aspect") + "_"));
        CellEditorManager.registerEditor(AccessoryAspect.class, () -> new DefaultTextCellEditor(new JTextField()), (EditorContext)DefaultTextCellEditor.CONTEXT);
        this.aspectTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.aspectTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.aspectTable.adjustRowHeight();
        this.aspectTable.setSelectionMode(0);
        this.aspectTable.setSortable(false);
        this.aspectTable.getInputMap(1).put(AccessoryTableMenu.KEYSTROKE_CUT, "cut");
        this.aspectTable.getActionMap().put("cut", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.aspectTable.getInputMap(1).put(AccessoryTableMenu.KEYSTROKE_COPY, "copy");
        this.aspectTable.getActionMap().put("copy", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.aspectTable.getInputMap(1).put(AccessoryTableMenu.KEYSTROKE_PASTE, "paste");
        this.aspectTable.getActionMap().put("paste", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.aspectTable.getInputMap(1).put(AccessoryTableMenu.KEYSTROKE_DELETE, "delete");
        this.aspectTable.getActionMap().put("delete", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.tableModel.addPortListener((AccessoryPortListener)new /* Unavailable Anonymous Inner Class!! */);
        DefaultOverlayable defaultOverlayable = new DefaultOverlayable((JComponent)new JScrollPane((Component)this.aspectTable));
        this.tableModel.addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        defaultOverlayable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.aspectTable.getEmptyTableText() + ":f:gray}")));
        formBuilder.appendRows("3dlu, fill:300px:grow", new Object[0]);
        formBuilder.add((Component)defaultOverlayable).xyw(1, 7, 13);
        IconFeedbackPanel iconPanel = new IconFeedbackPanel(this.validationModel, (JComponent)formBuilder.build());
        this.add((Component)iconPanel, (Object)"Center");
        this.mainModel.addAccessorySelectionListener((AccessorySelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ValueModel getSaveButtonEnabledModel() {
        return this.saveButtonEnabledModel;
    }

    protected void initialize() {
        this.accessoryErrorIcon = ImageUtils.createImageIcon(AccessoryPanel.class, (String)"/icons/accessory-error.png");
        this.accessorySuccessfulIcon = ImageUtils.createImageIcon(AccessoryPanel.class, (String)"/icons/accessory-successful.png");
        this.accessoryWaitIcon = ImageUtils.createImageIcon(AccessoryPanel.class, (String)"/icons/accessory-wait.png");
        this.accessoryUnknownIcon = ImageUtils.createImageIcon(AccessoryPanel.class, (String)"/icons/accessory-unknown.png");
    }

    @Override
    public void validate() {
        AccessoryAspectParam param;
        LOGGER.debug("Validate the values.");
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.selectionHolderStartupAspect, "validation");
        AccessoryAspect accessoryAspect = this.accessoryStartupAspectModel.getSelectedStartupAspect();
        if (accessoryAspect instanceof AccessoryAspectParam && (param = (AccessoryAspectParam)accessoryAspect).isInvalid()) {
            support.addError("startupAspect_key", "invalid_value");
        }
        ValidationResult validationResult = support.getResult();
        this.validationModel.setResult(validationResult);
        boolean hasErrors = this.validationModel.hasErrors();
        LOGGER.info("The current model has errors: {}", (Object)hasErrors);
        this.updateSaveButtonEnabled(hasErrors);
        if (this.selectedAccessoryValueModel.getValue() != null) {
            try {
                Accessory selectedAccessory = (Accessory)this.selectedAccessoryValueModel.getValue();
                selectedAccessory.setError(hasErrors);
            }
            catch (Exception ex) {
                LOGGER.warn("The selected accessory has an error.", (Throwable)ex);
            }
        } else {
            LOGGER.info("No selected accessory available.");
        }
    }

    private void updateSaveButtonEnabled(boolean validationHasErrors) {
        LOGGER.debug("Update the save button, validationHasErrors: {}", (Object)validationHasErrors);
        this.saveButtonEnabledModel.setValue((Object)(!validationHasErrors ? 1 : 0));
    }

    private void fireTestButtonPressed(int aspectNumber) {
        int result;
        Accessory accessory = this.selectedAccessoryModel.getSelectedAccessory();
        if (accessory != null && AccessorySaveState.PERMANENTLY_STORED_ON_NODE != accessory.getAccessorySaveState() && (result = JOptionPane.showConfirmDialog((Component)this, Resources.getString(AccessoryPanel.class, (String)"accessory_transfer_pending_changes_before_test"), Resources.getString(AccessoryPanel.class, (String)"test"), 0, 2)) == 0) {
            this.accessoryPanelController.storeAccessory(accessory);
        }
        this.accessoryPanelController.activateAspect(accessory, aspectNumber);
    }

    private int getRow(Point point) {
        return this.aspectTable.rowAtPoint(point);
    }

    private void handleMouseEvent(MouseEvent e, AccessoryTableMenu popupMenu) {
        if (e.isPopupTrigger()) {
            int selectedRow;
            int row = this.getRow(e.getPoint());
            if (this.aspectTable.getCellEditor() != null) {
                this.aspectTable.getCellEditor().cancelCellEditing();
            }
            if (this.aspectTable.getSelectedRowCount() == 0 && this.aspectTable.getRowCount() > 0 && row >= 0 && row < this.aspectTable.getRowCount()) {
                this.aspectTable.setRowSelectionInterval(row, row);
            }
            if ((selectedRow = this.aspectTable.getSelectedRow()) > -1) {
                try {
                    boolean immutable;
                    Object value = this.tableModel.getValueAt(selectedRow, 2);
                    if (value instanceof AccessoryAspectMacro && (immutable = ((AccessoryAspectMacro)value).isImmutableAccessory())) {
                        popupMenu.updateImmutableMenuItems();
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Update menu items for immutable aspect failed.", (Throwable)ex);
                }
            }
            this.aspectTable.requestFocusInWindow();
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void executionStateChanged(AccessoryExecutionState executionState, Integer accessoryId, Integer aspect, AccessoryState accessoryState) {
        LOGGER.info("The execution state has changed: {}, accessoryId: {}, aspect: {}", new Object[]{executionState, accessoryId, aspect});
        if (aspect == null || executionState == null) {
            executionState = AccessoryExecutionState.IDLE;
        }
        this.executionStateIconLabel.setToolTipText(null);
        switch (13.$SwitchMap$org$bidib$jbidibc$messages$enums$AccessoryExecutionState[executionState.ordinal()]) {
            case 1: {
                this.executionStateIconLabel.setIcon(this.accessoryErrorIcon);
                if (accessoryState == null) break;
                this.executionStateIconLabel.setToolTipText(accessoryState.getErrorInformation());
                break;
            }
            case 2: {
                this.executionStateIconLabel.setIcon(this.accessoryWaitIcon);
                break;
            }
            case 3: {
                this.executionStateIconLabel.setIcon(this.accessorySuccessfulIcon);
                break;
            }
            case 4: {
                this.executionStateIconLabel.setIcon(this.accessoryUnknownIcon);
                break;
            }
            default: {
                this.executionStateIconLabel.setIcon(null);
            }
        }
        if (this.selectedAccessoryModel.getSelectedAccessory() != null) {
            Accessory accessory = this.selectedAccessoryModel.getSelectedAccessory();
            this.refreshCurrentAspectLabel(accessory, aspect, accessoryState);
        }
    }

    private void refreshCurrentAspectLabel(Accessory accessory, Integer aspect, AccessoryState accessoryState) {
        LOGGER.info("The selected accessory: {}, active aspect: {}", (Object)accessory, (Object)aspect);
        this.currentAspectLabel.setText(null);
        if (accessoryState != null && !accessoryState.hasError() && aspect != null && aspect < this.tableModel.getRowCount()) {
            Object value = this.tableModel.getValueAt(aspect.intValue(), 0);
            if (value == null) {
                value = Resources.getString(AccessoryTableModel.class, (String)"aspect") + "_" + aspect;
            }
            this.currentAspectLabel.setText(Resources.getString(AccessoryPanel.class, (String)"activeAspect", (Object[])new Object[]{String.format("%1$02d : %2$s", aspect, value)}));
        }
    }

    public void labelChanged(String label) {
    }

    private void loadStepControlMovingAspects(AccessoryLabel accessoryLabel) {
        LOGGER.info("Load the StepControl moving aspects.");
        this.tableModel.setRowCount(0);
        this.accessoryStartupAspectModel.clearAccessoryAspects();
        int aspectNumber = 0;
        for (StepControlAspect stepControlAspect : this.stepControlAspects) {
            LOGGER.info("Create accessory aspect for stepControlAspect: {}", (Object)stepControlAspect);
            AccessoryAspectMacro aspectTurntable = new AccessoryAspectMacro(aspectNumber, null);
            aspectTurntable.setImmutableAccessory(true);
            aspectTurntable.setLabel(this.getAccessoryAspectLabel(accessoryLabel, aspectNumber));
            this.tableModel.addRow((AccessoryAspect)aspectTurntable);
            this.accessoryStartupAspectModel.addAccessoryAspect((AccessoryAspect)aspectTurntable);
            ++aspectNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void macrosChanged() {
        Accessory selectedAccessory;
        LOGGER.info("The macros have changed.");
        this.tableModel.setRowCount(0);
        this.accessoryStartupAspectModel.clearAccessoryAspects();
        if (this.stepControlAspects != null) {
            if (this.stepControlAspectsListener != null) {
                this.stepControlAspects.removeListDataListener(this.stepControlAspectsListener);
            }
            this.stepControlAspects = null;
        }
        if ((selectedAccessory = this.tableModel.getSelectedAccessory()) != null) {
            NodeInterface selectedNode = this.accessoryPanelController.getSelectedNode();
            long uniqueId = this.accessoryPanelController.getSelectedNode().getUniqueId();
            boolean isStepControl = ProductUtils.isStepControl((long)uniqueId);
            if (isStepControl && selectedAccessory.getId() < 3) {
                LOGGER.info("Special processing for StepControl.");
                this.prepareStepControlAspects(selectedNode, selectedAccessory);
            } else if (selectedAccessory.isUsesStrings().booleanValue()) {
                this.applyTextAccessory(selectedNode, selectedAccessory);
            } else {
                this.applyAccessoryLabels(selectedAccessory);
            }
        }
        try {
            this.accessoryStartupAspectModel.removePropertyChangeListener("selectedStartupAspect", this.startupAspectChangeListener);
            if (selectedAccessory != null && selectedAccessory.getStartupState() != null) {
                int aspectCount = selectedAccessory.isMacroMapped() && selectedAccessory.getAspectCount() > 0 ? selectedAccessory.getAspectCount() : selectedAccessory.getTotalAspects();
                try {
                    AccessoryAspect startupAspect = this.accessoryStartupAspectModel.getAssignedAspect(selectedAccessory.getStartupState().intValue(), aspectCount);
                    this.accessoryStartupAspectModel.setSelectedStartupAspect(startupAspect);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the selected startup aspect failed. Set the invalid aspect.", (Throwable)ex);
                    this.accessoryStartupAspectModel.setSelectedStartupAspect((AccessoryAspect)this.startupAspectSelection.getElementAt(0));
                }
            } else {
                LOGGER.info("No startup aspect available.");
                this.accessoryStartupAspectModel.setSelectedStartupAspect(null);
            }
            AccessoryAspect accessoryAspect = this.accessoryStartupAspectModel.getSelectedStartupAspect();
            boolean startupAspectEnabled = accessoryAspect != null;
            LOGGER.info("The startup aspect has changed, startupAspectEnabled: {}, selected startup aspect: {}", (Object)startupAspectEnabled, (Object)accessoryAspect);
            this.labelInitialState.setEnabled(startupAspectEnabled);
            this.comboStartupAspect.setEnabled(startupAspectEnabled);
        }
        finally {
            this.accessoryStartupAspectModel.addPropertyChangeListener("selectedStartupAspect", this.startupAspectChangeListener);
        }
        try {
            this.accessorySwitchTimeModel.removePropertyChangeListener(this.switchTimeChangeListener);
            boolean switchTimeEnabled = selectedAccessory != null && selectedAccessory.getSwitchTime() != null;
            LOGGER.info("The accessory switch time has changed, startupAspectEnabled: {}", (Object)switchTimeEnabled);
            for (JComponent comp : this.baseUnitButtons) {
                comp.setEnabled(switchTimeEnabled);
            }
            this.switchTimeText.setEnabled(switchTimeEnabled);
            this.labelSwitchTime.setEnabled(switchTimeEnabled);
            if (switchTimeEnabled) {
                Integer switchTime = selectedAccessory.getSwitchTime();
                TimeBaseUnitEnum timeBaseUnit = selectedAccessory.getTimeBaseUnit();
                this.accessorySwitchTimeModel.setSwitchTime(switchTime);
                this.accessorySwitchTimeModel.setTimeBaseUnit(timeBaseUnit);
            } else {
                this.accessorySwitchTimeModel.setSwitchTime(null);
                this.accessorySwitchTimeModel.setTimeBaseUnit(null);
            }
        }
        finally {
            this.accessorySwitchTimeModel.addPropertyChangeListener(this.switchTimeChangeListener);
        }
        this.validate();
    }

    private void prepareStepControlAspects(NodeInterface selectedNode, Accessory selectedAccessory) {
        NodeLabels nodeLabels;
        AccessoryLabels accessoryLabels = null;
        VendorCV vendorCv = selectedNode.getVendorCV().getVendorCV();
        if (vendorCv.getExtension() != null && CollectionUtils.isNotEmpty((Collection)vendorCv.getExtension().getNodeLabels()) && (nodeLabels = (NodeLabels)vendorCv.getExtension().getNodeLabels().get(0)) != null) {
            LOGGER.info("Use node labels from extension in vendorCV.");
            accessoryLabels = nodeLabels.getAccessoryLabels();
        }
        LOGGER.info("Current accessory id: {}", (Object)selectedAccessory.getId());
        switch (selectedAccessory.getId()) {
            case 0: {
                AccessoryLabel accessoryLabel;
                try {
                    accessoryLabel = this.accessoryPanelController.getAccessoryAspectsLabels(selectedAccessory.getId().intValue());
                    StepControlControllerInterface controller = (StepControlControllerInterface)DefaultApplicationContext.getInstance().get("stepControlController", StepControlControllerInterface.class);
                    this.stepControlAspects = controller.getConfigureAspectsListModel();
                    if (this.stepControlAspectsListener == null) {
                        LOGGER.info("Create new stepControlAspectsListener.");
                        this.stepControlAspectsListener = new /* Unavailable Anonymous Inner Class!! */;
                        LOGGER.info("Created new instance of stepControlAspectsListener: {}", (Object)this.stepControlAspectsListener);
                    }
                    this.stepControlAspects.addListDataListener(this.stepControlAspectsListener);
                    this.loadStepControlMovingAspects(accessoryLabel);
                }
                catch (Exception ex) {
                    LOGGER.warn("Load configured moving aspects failed", (Throwable)ex);
                }
                break;
            }
            case 1: {
                AccessoryLabel accessoryLabel;
                if (CollectionUtils.isNotEmpty((Collection)selectedAccessory.getAspects()) || selectedAccessory.getTotalAspects() > 0) {
                    accessoryLabel = null;
                    if (accessoryLabels != null) {
                        accessoryLabel = AccessoryLabelUtils.getAccessoryLabel((AccessoryLabels)accessoryLabels, (int)selectedAccessory.getId());
                    }
                    if (accessoryLabel == null) {
                        accessoryLabel = this.accessoryPanelController.getAccessoryAspectsLabels(selectedAccessory.getId().intValue());
                    }
                    int totalAspects = 0;
                    totalAspects = CollectionUtils.isNotEmpty((Collection)selectedAccessory.getAspects()) ? selectedAccessory.getAspects().size() : selectedAccessory.getTotalAspects();
                    LOGGER.info("The homing accessory has totalAspects: {}", (Object)totalAspects);
                    for (int row = 0; row < totalAspects; ++row) {
                        LOGGER.info("Adding new aspect, row: {}", (Object)row);
                        AccessoryAspectMacro accessoryAspect = new AccessoryAspectMacro(row, null);
                        accessoryAspect.setLabel(this.getAccessoryAspectLabel(accessoryLabel, row));
                        accessoryAspect.setImmutableAccessory(true);
                        this.tableModel.addRow((AccessoryAspect)accessoryAspect);
                        this.accessoryStartupAspectModel.addAccessoryAspect((AccessoryAspect)accessoryAspect);
                    }
                    break;
                }
                LOGGER.warn("No aspects for HOMING accessory available.");
                break;
            }
            default: {
                if (!CollectionUtils.isNotEmpty((Collection)selectedAccessory.getAspects()) && selectedAccessory.getTotalAspects() <= 0) break;
                AccessoryLabel accessoryLabel = null;
                if (accessoryLabels != null) {
                    accessoryLabel = AccessoryLabelUtils.getAccessoryLabel((AccessoryLabels)accessoryLabels, (int)selectedAccessory.getId());
                }
                if (accessoryLabel == null) {
                    accessoryLabel = this.accessoryPanelController.getAccessoryAspectsLabels(selectedAccessory.getId().intValue());
                }
                int totalAspects = 0;
                totalAspects = CollectionUtils.isNotEmpty((Collection)selectedAccessory.getAspects()) ? selectedAccessory.getAspects().size() : selectedAccessory.getTotalAspects();
                LOGGER.info("The sound accessory has totalAspects: {}", (Object)totalAspects);
                for (int row = 0; row < totalAspects; ++row) {
                    LOGGER.info("Adding new aspect, row: {}", (Object)row);
                    AccessoryAspectMacro accessoryAspect = new AccessoryAspectMacro(row, null);
                    accessoryAspect.setLabel(this.getAccessoryAspectLabel(accessoryLabel, row));
                    accessoryAspect.setImmutableAccessory(true);
                    this.tableModel.addRow((AccessoryAspect)accessoryAspect);
                    this.accessoryStartupAspectModel.addAccessoryAspect((AccessoryAspect)accessoryAspect);
                }
            }
        }
    }

    private void applyTextAccessory(NodeInterface selectedNode, Accessory selectedAccessory) {
        LOGGER.info("Apply text accessory.");
        StoredStrings storedStringsNs2 = selectedNode.getStoredStringsNs2();
        if (storedStringsNs2 != null) {
            int totalAspects = storedStringsNs2.getMaxItems();
            for (int row = 0; row < totalAspects; ++row) {
                AccessoryAspectMacro accessoryAspect = new AccessoryAspectMacro(row, null);
                String textAccessoryText = (String)storedStringsNs2.getStoredStrings().get(row);
                accessoryAspect.setLabel(textAccessoryText);
                accessoryAspect.setImmutableAccessory(true);
                this.tableModel.addRow((AccessoryAspect)accessoryAspect);
                this.accessoryStartupAspectModel.addAccessoryAspect((AccessoryAspect)accessoryAspect);
            }
        } else {
            LOGGER.warn("No StoredStrings available.");
        }
    }

    public void handleStringChanged(int index, String value) {
        LOGGER.debug("Set the new accessory string, index: {}, value: {}", (Object)index, (Object)value);
        this.tableModel.setValueAt((Object)value, index, 0);
    }

    private void applyAccessoryLabels(Accessory selectedAccessory) {
        AccessoryLabel accessoryLabel = this.accessoryPanelController.getAccessoryAspectsLabels(selectedAccessory.getId().intValue());
        if (CollectionUtils.isNotEmpty((Collection)selectedAccessory.getAspects())) {
            List macros = this.accessoryPanelController.getMacros();
            MacroRef[] aspects = selectedAccessory.getAspects().toArray(new MacroRef[0]);
            for (int row = 0; row < aspects.length; ++row) {
                MacroRef currentMacro = aspects[row];
                if (currentMacro == null || currentMacro.getId() == null) continue;
                int macroNumber = currentMacro.getId();
                LOGGER.info("Adding new aspect, row: {}, macroNumber: {}", (Object)row, (Object)macroNumber);
                if (macroNumber <= -1 || macroNumber >= macros.size()) continue;
                AccessoryAspectMacro accessoryAspect = new AccessoryAspectMacro(row, currentMacro);
                accessoryAspect.setLabel(this.getAccessoryAspectLabel(accessoryLabel, row));
                this.tableModel.addRow((AccessoryAspect)accessoryAspect);
                this.accessoryStartupAspectModel.addAccessoryAspect((AccessoryAspect)accessoryAspect);
            }
        } else if (selectedAccessory.getTotalAspects() > 0) {
            int totalAspects = selectedAccessory.getTotalAspects();
            if (totalAspects > 0) {
                for (int row = 0; row < totalAspects; ++row) {
                    AccessoryAspectMacro accessoryAspect = new AccessoryAspectMacro(row, null);
                    accessoryAspect.setLabel(this.getAccessoryAspectLabel(accessoryLabel, row));
                    accessoryAspect.setImmutableAccessory(true);
                    this.tableModel.addRow((AccessoryAspect)accessoryAspect);
                    this.accessoryStartupAspectModel.addAccessoryAspect((AccessoryAspect)accessoryAspect);
                }
            }
        } else {
            LOGGER.warn("No aspects available for accessory: {}", (Object)selectedAccessory);
        }
    }

    private String getAccessoryAspectLabel(AccessoryLabel labels, int aspectIndex) {
        BaseLabel baseLabel;
        if (labels != null && (baseLabel = AccessoryLabelUtils.getAccessoryAspectLabel((AccessoryLabel)labels, (int)aspectIndex)) != null) {
            String labelString = baseLabel.getLabel();
            LOGGER.info("Found the aspect label: {}", (Object)labelString);
            return labelString;
        }
        return null;
    }

    public void accessoryStateChanged(Integer accessoryId, Integer aspect) {
        LOGGER.info("The accessory state has changed for accessory id: {}, aspect: {}", (Object)accessoryId, (Object)aspect);
        SwingUtils.executeInEDT(() -> this.processAccessoryStateChanged(accessoryId, aspect));
    }

    private void processAccessoryStateChanged(Integer accessoryId, Integer aspect) {
        Accessory selectedAccessory = this.tableModel.getSelectedAccessory();
        if (selectedAccessory != null && selectedAccessory.getId() == accessoryId) {
            AccessoryExecutionState executionState = selectedAccessory.getAccessoryExecutionState();
            AccessoryState accessoryState = selectedAccessory.getAccessoryState();
            this.executionStateChanged(executionState, accessoryId, aspect, accessoryState);
        } else {
            this.executionStateChanged(null, accessoryId, aspect, null);
        }
    }

    private void fireAspectLabelChanged(int accessoryId, int aspectIndex) {
        String label = null;
        if (aspectIndex < this.tableModel.getRowCount()) {
            label = (String)this.tableModel.getValueAt(aspectIndex, 0);
            MacroRef aspect = null;
            List aspects = this.selectedAccessoryModel.getSelectedAccessory().getAspects();
            if (aspects.size() > aspectIndex) {
                aspect = aspects.toArray(new MacroRef[0])[aspectIndex];
            }
            LOGGER.info("The aspect label has changed, accessoryId: {}, aspectIndex: {}, label: {}", new Object[]{accessoryId, aspectIndex, label});
            label = StringUtils.trimToNull((String)label);
            if (aspect != null) {
                LOGGER.info("Set the changed label on aspect: {}, label: {}", (Object)aspect, (Object)label);
                aspect.setLabel(label);
            }
        }
        boolean isUsesStrings = this.selectedAccessoryModel.getSelectedAccessory() != null && this.selectedAccessoryModel.getSelectedAccessory().isUsesStrings() != false;
        this.accessoryPanelController.setAccessoryAspectLabel(accessoryId, aspectIndex, label, isUsesStrings);
    }

    private MacroRef[] getMacros(int[] rows) {
        MacroRef[] result = new MacroRef[rows.length];
        try {
            Accessory selectedAccessory = this.selectedAccessoryModel.getSelectedAccessory();
            MacroRef[] aspects = selectedAccessory.getAspects().toArray(new MacroRef[0]);
            for (int index = 0; index < rows.length; ++index) {
                result[index] = aspects[rows[index]];
            }
            LOGGER.info("Prepared macros: {}", new Object[]{result});
        }
        catch (Exception ex) {
            LOGGER.warn("Get selected macros failed.", (Throwable)ex);
        }
        return result;
    }

    public void saveAccessory(Accessory selectedAccessory) {
        LOGGER.info("Save the values to the selected accessory: {}", (Object)selectedAccessory);
        if (this.accessoryStartupAspectModel.getSelectedStartupAspect() instanceof AccessoryAspectMacro) {
            AccessoryAspectMacro accessoryAspectMacro = (AccessoryAspectMacro)this.accessoryStartupAspectModel.getSelectedStartupAspect();
            Integer startupState = accessoryAspectMacro.getIndex();
            LOGGER.info("Set the startup state: {}", (Object)startupState);
            selectedAccessory.setStartupState(startupState);
        } else if (this.accessoryStartupAspectModel.getSelectedStartupAspect() instanceof AccessoryAspectParam) {
            AccessoryAspectParam accessoryAspectParam = (AccessoryAspectParam)this.accessoryStartupAspectModel.getSelectedStartupAspect();
            if (accessoryAspectParam.isInvalid()) {
                LOGGER.warn("The startup aspect is invalid.");
                throw new IllegalArgumentException("The startup aspect is invalid.");
            }
            Integer startupState = accessoryAspectParam.getParam();
            LOGGER.info("Set the startup state of the param: {}", (Object)startupState);
            selectedAccessory.setStartupState(startupState);
        } else {
            LOGGER.info("The startup state is not an macro aspect or a param: {}", (Object)this.accessoryStartupAspectModel.getSelectedStartupAspect());
        }
    }

    private void setMacrosToClipboard(MacroRef[] macros) {
        if (macros != null) {
            try {
                this.macrosClipBoard = new MacroRef[macros.length];
                for (int index = 0; index < macros.length; ++index) {
                    if (macros[index] == null) continue;
                    this.macrosClipBoard[index] = new MacroRef(macros[index].getId());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.macrosClipBoard = null;
        }
    }

    private MacroRef[] getMacrosFromClipboard() {
        MacroRef[] result = null;
        if (this.macrosClipBoard != null) {
            try {
                result = new MacroRef[this.macrosClipBoard.length];
                for (int index = 0; index < this.macrosClipBoard.length; ++index) {
                    if (this.macrosClipBoard[index] == null) continue;
                    result[index] = new MacroRef(this.macrosClipBoard[index].getId());
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Get macros from clipboard failed.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    private void fireDelete(int[] rows) {
        LOGGER.info("Delete the aspect row at index: {}", (Object)rows[0]);
        if (rows.length == 0) {
            return;
        }
        AccessoryTableModel accessoryTableModel = this.tableModel;
        int currentIndex = 0;
        for (currentIndex = rows[0]; currentIndex < accessoryTableModel.getRowCount() - 1; ++currentIndex) {
            LOGGER.info("Current index: {}", (Object)currentIndex);
            AccessoryAspect accessoryAspect = accessoryTableModel.getAccessoryAspectInstance(currentIndex + 1);
            if (accessoryAspect instanceof AccessoryAspectMacro) {
                AccessoryAspectMacro source = (AccessoryAspectMacro)accessoryAspect;
                LOGGER.info("Current source label: {}, macro: {}", (Object)source, (Object)source.getMacroRef());
                accessoryTableModel.setValueAt((Object)source.getMacroRef(), currentIndex, 1);
            }
            accessoryTableModel.setValueAt((Object)accessoryAspect.getLabel(), currentIndex, 0);
        }
        LOGGER.info("Delete the aspect at index: {}", (Object)currentIndex);
        this.selectedAccessoryModel.getSelectedAccessory().removeAspect(currentIndex);
        this.fireAspectLabelChanged(this.selectedAccessoryModel.getSelectedAccessory().getId().intValue(), currentIndex);
        accessoryTableModel.fireTableDataChanged();
    }

    private MacroRef findNextFreeMacro() {
        TreeSet<Integer> macroIds = new TreeSet<Integer>();
        for (Object accessory : this.mainModel.getAccessories()) {
            for (MacroRef aspect : accessory.getAspects()) {
                macroIds.add(aspect.getId());
            }
        }
        int macroId = 0;
        for (Integer currentId : macroIds) {
            if (currentId == macroId) {
                ++macroId;
                continue;
            }
            LOGGER.info("Found free macroId: {}", (Object)macroId);
        }
        MacroRef macroRef = null;
        if (macroId < this.mainModel.getMacros().size()) {
            LOGGER.info("Create new MacroRef with macroId: {}", (Object)macroId);
            macroRef = new MacroRef(Integer.valueOf(macroId));
        } else {
            macroRef = new MacroRef();
        }
        return macroRef;
    }

    private void fireInsertEmptyAfter(int row) {
        MacroRef macroRef = this.findNextFreeMacro();
        this.selectedAccessoryModel.getSelectedAccessory().addAspectAfter(row, macroRef);
    }

    private void fireInsertEmptyBefore(int row) {
        MacroRef macroRef = this.findNextFreeMacro();
        this.selectedAccessoryModel.getSelectedAccessory().addAspectBefore(row >= 0 ? row : 0, macroRef);
    }

    private void fireCopy(int[] rows) {
        this.setMacrosToClipboard(this.getMacros(rows));
    }

    private void fireCut(int[] rows) {
        MacroRef[] macros = this.getMacros(rows);
        this.setMacrosToClipboard(macros);
        for (int index = rows.length - 1; index >= 0; --index) {
            this.selectedAccessoryModel.getSelectedAccessory().removeAspect(rows[index]);
        }
    }

    private void firePasteAfter(int row) {
        MacroRef[] macros = this.getMacrosFromClipboard();
        if (macros != null) {
            this.selectedAccessoryModel.getSelectedAccessory().addAspectsAfter(row, macros);
        } else {
            MacroRef macroRef = this.findNextFreeMacro();
            this.selectedAccessoryModel.getSelectedAccessory().addAspectAfter(row, macroRef);
        }
    }

    public void changeLabel(AccessoryAspectTargetType aspectTargetType) {
        LOGGER.info("Change the label of the aspect: {}", (Object)aspectTargetType);
        int accessoryNumber = aspectTargetType.getAccessoryNum();
        int aspectNumber = aspectTargetType.getPortNum();
        String aspectLabel = aspectTargetType.getLabel();
        Accessory selectedAccessory = this.selectedAccessoryModel.getSelectedAccessory();
        if (selectedAccessory != null && selectedAccessory.getId() == accessoryNumber) {
            if (this.tableModel.getRowCount() < aspectNumber + 1) {
                for (int row = this.tableModel.getRowCount(); row < aspectNumber + 1; ++row) {
                    LOGGER.info("Add new row: {}", (Object)row);
                    this.tableModel.addRow((AccessoryAspect)new AccessoryAspectMacro(aspectNumber, null));
                }
            }
            this.tableModel.setValueAt((Object)aspectLabel, aspectNumber, 0);
        } else {
            boolean isUsesStrings = this.selectedAccessoryModel.getSelectedAccessory() != null && this.selectedAccessoryModel.getSelectedAccessory().isUsesStrings() != false;
            this.accessoryPanelController.setAccessoryAspectLabel(accessoryNumber, aspectNumber, aspectLabel, isUsesStrings);
        }
    }

    public void refreshView() {
        this.macrosChanged();
        Accessory accessory = this.selectedAccessoryModel.getSelectedAccessory();
        if (accessory != null && accessory.getAccessoryState() != null) {
            Integer currentAspect = accessory.getAccessoryState().getActiveAspect();
            this.refreshCurrentAspectLabel(accessory, currentAspect, accessory.getAccessoryState());
        }
    }
}

