/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.statusbar;

import com.jidesoft.status.StatusBarItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.bidib.wizard.api.model.listener.StatusListener;
import org.bidib.wizard.client.common.led.LED;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.mvc.main.model.StatusModel;
import org.bidib.wizard.mvc.main.view.statusbar.ConnectionStatusBarItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionStatusBarItem
extends StatusBarItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionStatusBarItem.class);
    private static final long serialVersionUID = 1L;

    public ConnectionStatusBarItem(StatusModel statusModel) {
        this(statusModel, Axis.lineAxis);
    }

    public ConnectionStatusBarItem(StatusModel statusModel, Axis axis) {
        Color colorOn = UIManager.getColor("ConnectionStatusBarItem.led_on");
        Color colorOff = UIManager.getColor("ConnectionStatusBarItem.led_off");
        if (colorOn == null) {
            colorOn = Color.red;
        }
        if (colorOff == null) {
            colorOff = Color.gray;
        }
        LED connectLed = new LED(colorOn, colorOff, 1000);
        connectLed.setName("CD");
        this.setLedStatus(connectLed, statusModel.isCd());
        LED receiveLed = new LED(colorOn, colorOff, 1000);
        receiveLed.setName("RX");
        this.setLedStatus(receiveLed, statusModel.isRx());
        LED sendLed = new LED(colorOn, colorOff, 1000);
        sendLed.setName("TX");
        this.setLedStatus(sendLed, statusModel.isTx());
        LED ctsLed = new LED(colorOn, colorOff, 1000);
        ctsLed.setName("CTS");
        this.setLedStatus(ctsLed, statusModel.isCd());
        if (Axis.pageAxis.equals((Object)axis)) {
            this.setLayout((LayoutManager)new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(5, 3, 5, 3);
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)connectLed, (Object)c);
            ++c.gridx;
            this.add((Component)receiveLed, (Object)c);
            ++c.gridx;
            this.add((Component)sendLed, (Object)c);
            ++c.gridx;
            this.add((Component)ctsLed, (Object)c);
            c.gridx = 0;
            ++c.gridy;
            this.add((Component)new JLabel("CD"), (Object)c);
            ++c.gridx;
            this.add((Component)new JLabel("RX"), (Object)c);
            ++c.gridx;
            this.add((Component)new JLabel("TX"), (Object)c);
            ++c.gridx;
            this.add((Component)new JLabel("CTS"), (Object)c);
        } else {
            connectLed.setBorder((Border)new EmptyBorder(2, 4, 2, 4));
            receiveLed.setBorder((Border)new EmptyBorder(2, 4, 2, 4));
            sendLed.setBorder((Border)new EmptyBorder(2, 4, 2, 4));
            ctsLed.setBorder((Border)new EmptyBorder(2, 4, 2, 4));
            this.setLayout((LayoutManager)new BoxLayout((Container)this, 2));
            this.add(Box.createHorizontalGlue());
            this.add((Component)new JLabel("CD"));
            this.add(Box.createRigidArea(new Dimension(3, 0)));
            this.add((Component)connectLed);
            this.add(Box.createRigidArea(new Dimension(3, 0)));
            this.add((Component)new JLabel("RX"));
            this.add(Box.createRigidArea(new Dimension(3, 0)));
            this.add((Component)receiveLed);
            this.add(Box.createRigidArea(new Dimension(3, 0)));
            this.add((Component)new JLabel("TX"));
            this.add(Box.createRigidArea(new Dimension(3, 0)));
            this.add((Component)sendLed);
            this.add(Box.createRigidArea(new Dimension(3, 0)));
            this.add((Component)new JLabel("CTS"));
            this.add(Box.createRigidArea(new Dimension(3, 0)));
            this.add((Component)ctsLed);
            this.add(Box.createHorizontalGlue());
        }
        statusModel.addStatusListener((StatusListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getItemName() {
        return "ConnectionStatusBarItem";
    }

    private void setLedStatus(LED led, boolean on) {
        LOGGER.trace("setLedStatus led: {}, on: {}", (Object)led.getName(), (Object)on);
        if (!this.isEnabled()) {
            LOGGER.trace("The led panel is disabled.");
            return;
        }
        SwingUtils.executeInEDT(() -> {
            if (on) {
                led.usePrimary();
            } else {
                led.useSecondary();
            }
        });
    }
}

