/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import io.reactivex.rxjava3.subjects.Subject;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortEditorPanel;
import org.bidib.wizard.client.common.table.listener.PortEditorPanelCallback;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.model.InputPortTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundPortEditorPanel
extends AbstractPortEditorPanel<SoundPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundPortEditorPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private JTextField portName;

    public SoundPortEditorPanel(SoundPort port, Consumer<SoundPort> saveCallback, Consumer<SoundPort> valueCallback, Consumer<SoundPort> refreshCallback, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super((Port)port, saveCallback, valueCallback, refreshCallback, portConfigChangeEventSubject, nodeSelectionProvider);
    }

    protected SoundPort clonePort(SoundPort port) {
        SoundPort clone = (SoundPort)SoundPort.builder().withStatus((BidibStatus)((SoundPortStatus)port.getStatus())).withRemappingEnabled(port.isRemappingEnabled()).withKnownPortConfigKeys(port.getKnownPortConfigKeys()).withId(port.getId()).withLabel(port.getLabel()).withEnabled(port.isEnabled()).withIsInactive(port.isInactive()).withPortIdentifier(port.getPortIdentifier()).build();
        return clone;
    }

    protected JPanel doCreateComponent(SoundPort port) {
        AbstractPortEditorPanel.PortEditorPanelDebugContainer panel;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new AbstractPortEditorPanel.PortEditorPanelDebugContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        ArrayList<JTextField> order = new ArrayList<JTextField>();
        int row = 1;
        BufferedValueModel bufferedPortNameModel = this.getPresentationModel().getBufferedModel("label");
        dialogBuilder.add(Resources.getString(InputPortTableModel.class, (String)"label") + ":", new Object[0]).xy(1, 1);
        this.portName = WizardComponentFactory.createTextField((ValueModel)bufferedPortNameModel, (boolean)false);
        this.portName.setEnabled(port.isEnabled());
        dialogBuilder.add((Component)this.portName).xyw(3, row, 3);
        order.add(this.portName);
        JPanel buttonPanel = this.getButtonPanel();
        dialogBuilder.add((Component)buttonPanel).xyw(1, row += 2, 5);
        this.addButtons(buttonPanel, order);
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.getValidationResultModel(), (JComponent)dialogBuilder.build());
            AbstractPortEditorPanel.PortEditorPanelContainer panel2 = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel((JPanel)panel2);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            this.setPanel(feedbackBuilder.build());
        } else {
            this.setPanel(dialogBuilder.build());
        }
        bufferedPortNameModel.addValueChangeListener(evt -> this.triggerValidation());
        this.enableComponents();
        this.triggerValidation();
        this.getPanel().setFocusCycleRoot(true);
        this.getPanel().setFocusTraversalPolicy(this.createFocusTransversalPolicy(order));
        return this.getPanel();
    }

    public void requestDefaultFocus() {
        this.portName.requestFocusInWindow();
    }

    protected void propertyChanged(PropertyChangeEvent evt) {
        LOGGER.info("The port property has been changed, propertyName: {}, new value: {}", (Object)evt.getPropertyName(), evt.getNewValue());
        super.propertyChanged(evt);
        SwingUtilities.invokeLater(() -> {
            try {
                switch (evt.getPropertyName()) {
                    case "status": 
                    case "portStatus": {
                        LOGGER.info("The port status has changed: {}", evt.getNewValue());
                        break;
                    }
                    case "portConfigChanged": {
                        break;
                    }
                    case "portTypeChanged": {
                        LOGGER.info("The port type has changed: {}", evt.getNewValue());
                        this.enableComponents();
                        break;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Update the status failed.", (Throwable)ex);
            }
        });
    }

    protected ValidationResult validate(SoundPort port) {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.getPresentationModel(), "validation");
        ValidationResult validationResult = support.getResult();
        return validationResult;
    }

    protected void doEnableComponents(SoundPort port) {
        boolean enabled = port.isEnabled();
        this.portName.setEnabled(enabled);
        super.doEnableComponents((Port)port);
    }
}

