/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.nodedebug.model;

import com.jgoodies.binding.beans.Model;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.UIManager;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.mvc.nodedebug.model.DebugConsoleModel;

public class DebugConsoleModel
extends Model {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CONSOLE_CONTENT = "consoleContent";
    public static final String PROPERTY_CONSOLE_CONTENT_SIZE = "consoleContentSize";
    public static final String PROPERTY_SEND_TEXT = "sendText";
    public static final String PROPERTY_TRANSMIT_ENABLED = "transmitEnabled";
    private List<ConsoleLine> consoleMessages = new LinkedList();
    private String sendText;
    private NodeInterface selectedNode;
    private Color colorRed = UIManager.getColor("Console.red");
    private Color colorBlue = UIManager.getColor("Console.blue");
    private Color colorGreen = UIManager.getColor("Console.green");
    private Color colorBlack = UIManager.getColor("Console.black");
    private Color colorGray = UIManager.getColor("Console.gray");

    public void addConsoleLine(ConsoleColor consoleColor, String line) {
        Color color = this.colorBlack;
        switch (1.$SwitchMap$org$bidib$wizard$api$service$console$ConsoleColor[consoleColor.ordinal()]) {
            case 1: {
                color = this.colorRed;
                break;
            }
            case 2: {
                color = this.colorBlue;
                break;
            }
            case 3: {
                color = this.colorGreen;
                break;
            }
            case 4: {
                color = this.colorGray;
                break;
            }
        }
        ConsoleLine consoleLine = new ConsoleLine(color, line);
        if (this.consoleMessages.size() > 250) {
            this.consoleMessages.remove(0);
        }
        this.consoleMessages.add(consoleLine);
        int index = this.consoleMessages.size() - 1;
        this.fireIndexedPropertyChange(PROPERTY_CONSOLE_CONTENT, index, null, (Object)consoleLine);
    }

    public void clear() {
        int oldSize = this.consoleMessages.size();
        this.consoleMessages.clear();
        this.firePropertyChange(PROPERTY_CONSOLE_CONTENT_SIZE, oldSize, this.consoleMessages.size());
    }

    public String getSendText() {
        return this.sendText;
    }

    public void setSendText(String sendText) {
        String oldValue = this.sendText;
        this.sendText = sendText;
        this.firePropertyChange(PROPERTY_SEND_TEXT, (Object)oldValue, (Object)sendText);
    }

    public NodeInterface getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(NodeInterface selectedNode) {
        boolean oldValue = this.isTransmitEnabled();
        this.selectedNode = selectedNode;
        boolean transmitEnabled = this.isTransmitEnabled();
        this.firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldValue, transmitEnabled);
    }

    public boolean isTransmitEnabled() {
        return this.getSelectedNode() != null && Feature.findFeature((Collection)this.getSelectedNode().getNode().getFeatures(), (int)FeatureEnum.FEATURE_STRING_DEBUG.getNumber()) != null;
    }
}

