package org.bidib.wizard.mvc.locolist.controller.listener;

import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.mvc.locolist.model.LocoLibraryModel;

public interface LocoTableControllerListener {

    /**
     * Query the loco list from the command station.
     * 
     * @param csQueryType
     *            the query type
     * @param locoAddress
     *            the loco address to search
     */
    void queryCommandStationList(CsQueryTypeEnum csQueryType, Integer locoAddress);

    /**
     * Push the loco data to the loco database in the mouse
     * 
     * @param entryId
     *            the entry id, allowed values {@code 1..8}
     * @param speedSteps
     *            the speed steps
     * @param address
     *            the address of the loco
     * @param locoName
     *            the name of the loco
     */
    void pushLocoToMouse(int entryId, int speedSteps, int address, String locoName);

    // /**
    // * Save the user devices list.
    // *
    // * @param userDevicesList
    // * the user devices list
    // */
    // void saveUserDevicesList(final UserDevicesList userDevicesList);

    /**
     * Set the loco library model.
     * 
     * @param locoLibrary
     *            the loco library model
     */
    void setLocoLibraryModel(final LocoLibraryModel locoLibrary);

    /**
     * Open the loco dialog for the provided loco model.
     * 
     * @param locoModel
     *            the loco model
     */
    void openLocoDialog(final LocoListModel locoModel);

    /**
     * Open the pom dialog for the provided loco model.
     * 
     * @param locoModel
     *            the loco model
     */
    void openPomDialog(final LocoListModel locoModel);

    /**
     * Delete the loco from the dcc refresh and from the stored locos.
     * 
     * @param locoModel
     *            the loco model
     */
    void deleteLoco(LocoListModel locoModel);

    /**
     * Edit the provided loco.
     * 
     * @param locoModel
     *            the loco model
     */
    void editLoco(LocoListModel locoModel);

    /**
     * Add new loco.
     */
    void addLoco();
}
