package org.bidib.wizard.mvc.main.gauges;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

import eu.hansolo.steelseries.gauges.Radial;
import eu.hansolo.steelseries.tools.Section;

public class TestGauge {
    private static void createAndShowUI() {
        final JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLocationByPlatform(true);

        JPanel panel = new JPanel() {
            @Override
            public Dimension getPreferredSize() {
                return new Dimension(300, 300);
            }
        };

        final Radial gauge = new Radial();
        // final Radial1Vertical gauge = new Radial1Vertical();
        gauge.setTitle("Fahrstufe");
        gauge.setUnitString("");
        gauge.setNiceScale(false);
        gauge.setMaxValue(127);
        // gauge.setTrackStart(0);
        // gauge.setTrackStop(127);

        gauge.setThreshold(120);
        // gauge.setLcdDecimals(3);

        // gauge.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        // gauge.setFrameType(FrameType.ROUND);
        gauge.setFrameVisible(false);

        Section[] sections = new Section[3];

        sections[0] = new Section(0, 90, Color.GREEN.darker());
        sections[1] = new Section(90, 120, Color.ORANGE);
        sections[2] = new Section(120, gauge.getMaxValue(), Color.RED);
        gauge.setSections(sections);
        gauge.setSectionsVisible(true);

        panel.setLayout(new BorderLayout());
        panel.add(gauge, BorderLayout.CENTER);
        frame.add(panel);

        JPanel buttonsPanel = new JPanel();
        JLabel valueLabel = new JLabel("Value:");

        final JTextField valueField = new JTextField(3);
        valueField.setText("30");
        JButton button = new JButton("Set");
        button.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Double.valueOf(valueField.getText());
                    gauge.setValueAnimated(value);
                }
                catch (NumberFormatException ex) {
                    // TODO - handle invalid input
                    System.err.println("invalid input");
                }
            }
        });

        buttonsPanel.add(valueLabel);
        buttonsPanel.add(valueField);
        buttonsPanel.add(button);

        frame.add(buttonsPanel, BorderLayout.NORTH);

        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowUI();
            }
        });
    }
}
