package org.bidib.wizard.utils;

import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.core.schema.bidib2.FunctionAccessoryNotification;
import org.bidib.jbidibc.core.schema.bidib2.FunctionInput;
import org.bidib.jbidibc.core.schema.bidib2.MacroPoint;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointAccessoryNotification;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointInput;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputSwitch;
import org.bidib.wizard.api.model.function.AccessoryOkayFunction;
import org.bidib.wizard.api.model.function.InputFunction;
import org.bidib.wizard.api.model.function.SwitchPortAction;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.AccessoryOkayStatus;
import org.bidib.wizard.model.status.InputStatus;
import org.junit.jupiter.api.Test;

public class FunctionConversionFactoryTest {

    private FunctionConversionFactory factory = new FunctionConversionFactory();

    @Test
    public void convertSwitchPortAction() {
        SwitchPort port = new SwitchPort();
        port.setId(1);

        SwitchPortAction action = new SwitchPortAction(port, 50);

        MacroPoint macroPoint = factory.convert(action);
        Assertions.assertThat(macroPoint).isNotNull();
        Assertions.assertThat(macroPoint instanceof MacroPointOutputSwitch).isTrue();

        MacroPointOutputSwitch outputSwitch = (MacroPointOutputSwitch) macroPoint;
        Assertions.assertThat(outputSwitch.getOutputNumber()).isEqualTo(1);
        Assertions.assertThat(outputSwitch.getDelay()).isEqualTo(50);
    }

    @Test
    public void convertSwitchPortAction2() {
        SwitchPort port = new SwitchPort();
        port.setId(1);

        SwitchPortAction action = new SwitchPortAction(port, 50);

        MacroPoint macroPoint = factory.convertSwitchPortAction(action);
        Assertions.assertThat(macroPoint).isNotNull();
        Assertions.assertThat(macroPoint instanceof MacroPointOutputSwitch).isTrue();

        MacroPointOutputSwitch outputSwitch = (MacroPointOutputSwitch) macroPoint;
        Assertions.assertThat(outputSwitch.getOutputNumber()).isEqualTo(1);
        Assertions.assertThat(outputSwitch.getDelay()).isEqualTo(50);
    }

    @Test
    public void convertInputPortAction() {
        InputPort port = new InputPort();
        port.setId(1);

        InputFunction action = new InputFunction(InputStatus.QUERY1, port);

        MacroPoint macroPoint = factory.convertInputAction(action);
        Assertions.assertThat(macroPoint).isNotNull();
        Assertions.assertThat(macroPoint instanceof MacroPointInput).isTrue();

        MacroPointInput input = (MacroPointInput) macroPoint;
        Assertions.assertThat(input.getInputNumber()).isEqualTo(1);
        Assertions.assertThat(input.getFunction()).isEqualTo(FunctionInput.WAIT_FOR_1);
    }

    @Test
    public void convertAccessoryNotifyOkayAction() {
        AccessoryOkayFunction action = new AccessoryOkayFunction(AccessoryOkayStatus.NO_FEEDBACK);

        MacroPoint macroPoint = factory.convert(action);
        Assertions.assertThat(macroPoint).isNotNull();
        Assertions.assertThat(macroPoint instanceof MacroPointAccessoryNotification).isTrue();
        MacroPointAccessoryNotification accessoryNotification = (MacroPointAccessoryNotification) macroPoint;
        Assertions.assertThat(accessoryNotification.getFunction()).isNotNull();
        Assertions.assertThat(accessoryNotification.getFunction()).isEqualTo(FunctionAccessoryNotification.OKAY);
    }

    @Test
    public void convertAccessoryNotifyQuery0Action() {
        InputPort port = new InputPort();
        port.setId(1);
        AccessoryOkayFunction action = new AccessoryOkayFunction(AccessoryOkayStatus.QUERY0, port);

        MacroPoint macroPoint = factory.convert(action);
        Assertions.assertThat(macroPoint).isNotNull();
        Assertions.assertThat(macroPoint instanceof MacroPointAccessoryNotification).isTrue();
        MacroPointAccessoryNotification accessoryNotification = (MacroPointAccessoryNotification) macroPoint;
        Assertions.assertThat(accessoryNotification.getFunction()).isNotNull();
        Assertions
            .assertThat(accessoryNotification.getFunction()).isEqualTo(FunctionAccessoryNotification.OKAY_IF_INPUT_0);

        Assertions.assertThat(accessoryNotification.getInputNumber()).isNotNull();
        Assertions.assertThat(accessoryNotification.getInputNumber()).isEqualTo(Integer.valueOf(1));
    }

    @Test
    public void convertAccessoryNotifyQuery1Action() {
        InputPort port = new InputPort();
        port.setId(1);
        AccessoryOkayFunction action = new AccessoryOkayFunction(AccessoryOkayStatus.QUERY1, port);

        MacroPoint macroPoint = factory.convert(action);
        Assertions.assertThat(macroPoint).isNotNull();
        Assertions.assertThat(macroPoint instanceof MacroPointAccessoryNotification).isTrue();
        MacroPointAccessoryNotification accessoryNotification = (MacroPointAccessoryNotification) macroPoint;
        Assertions.assertThat(accessoryNotification.getFunction()).isNotNull();
        Assertions
            .assertThat(accessoryNotification.getFunction()).isEqualTo(FunctionAccessoryNotification.OKAY_IF_INPUT_1);

        Assertions.assertThat(accessoryNotification.getInputNumber()).isNotNull();
        Assertions.assertThat(accessoryNotification.getInputNumber()).isEqualTo(Integer.valueOf(1));
    }
}
