/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.bidib.wizard.mvc.common.view.graph.LedBarGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedBarGraph
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LedBarGraph.class);
    private final int totalLedsCount;
    private int totalHeight;
    private Color[] colors;
    private Color[] colorsInactive;
    private int value;
    private int singleLedHeight = 7;
    private int barWidth = 10;
    private int spaceLeft = 3;
    private int spaceRight = 3;
    private int textHeight = 20;
    private int textWidth = 30;
    private int totalWidth;
    private Font labelFont;
    private Color labelColor;
    private final Orientation orientation;

    public LedBarGraph(int totalLedsCount, Orientation orientation) {
        this.totalLedsCount = totalLedsCount;
        this.orientation = orientation;
        this.totalHeight = this.totalLedsCount * this.singleLedHeight + this.textHeight;
        this.colors = new Color[totalLedsCount];
        this.colorsInactive = new Color[totalLedsCount];
        for (int index = 0; index < this.colors.length; ++index) {
            this.colors[index] = index < 2 ? Color.RED : (index < 3 ? Color.ORANGE : Color.GREEN);
            this.colorsInactive[index] = this.colors[index].darker().darker().darker();
        }
        this.totalWidth = this.barWidth + this.spaceLeft + this.spaceRight;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.labelFont = UIManager.getDefaults().getFont("Label.font");
        this.labelColor = UIManager.getDefaults().getColor("Label.foreground");
    }

    public void setValue(int value) {
        LOGGER.info("Set value: {}", (Object)value);
        this.value = value;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int indexedValue = this.value / this.totalLedsCount;
        LOGGER.debug("new indexed value: {}", (Object)indexedValue);
        for (int index = 0; index < this.totalLedsCount; ++index) {
            if (indexedValue > index) {
                graphics.setColor(this.colors[index]);
            } else {
                graphics.setColor(this.colorsInactive[index]);
            }
            if (Orientation.vertical == this.orientation) {
                graphics.fillRect(this.spaceLeft, this.totalHeight - (index * this.singleLedHeight + this.textHeight), this.totalWidth, this.singleLedHeight - 1);
                continue;
            }
            graphics.fillRect(index * this.singleLedHeight + this.textWidth, this.spaceLeft, this.singleLedHeight - 1, this.totalWidth);
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(this.labelColor);
        g2d.setFont(this.labelFont);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (Orientation.vertical == this.orientation) {
            BasicGraphicsUtils.drawString(g2d, String.format("%2d%%", this.value), -1, this.spaceLeft, this.totalHeight);
        } else {
            BasicGraphicsUtils.drawString(g2d, String.format("%2d%%", this.value), -1, this.spaceLeft, this.totalWidth);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (Orientation.vertical == this.orientation) {
            return new Dimension(this.totalWidth + 10, this.totalHeight + this.singleLedHeight);
        }
        return new Dimension(this.totalHeight + this.singleLedHeight, this.totalWidth + 10);
    }

    @Override
    public Dimension getPreferredSize() {
        if (Orientation.vertical == this.orientation) {
            return new Dimension(this.totalWidth + 10, this.totalHeight + this.singleLedHeight);
        }
        return new Dimension(this.totalHeight + this.singleLedHeight, this.totalWidth + 10);
    }

    public int getTotalLedsCount() {
        return this.totalLedsCount;
    }
}

