/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.controller;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.PositionLocationEnum;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.model.connection.AbstractMessageEvent;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.api.model.connection.event.OccupancyCvMessageEvent;
import org.bidib.wizard.api.model.connection.event.OccupancyDynStateMessageEvent;
import org.bidib.wizard.api.model.connection.event.OccupancyPositionMessageEvent;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.core.LocoService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.WindowUtils;
import org.bidib.wizard.common.exception.ConnectionException;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.model.connection.MessageEventConsumer;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.model.loco.listener.LocoModelListener;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.RfBasisMode;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.common.DialogRegistry;
import org.bidib.wizard.mvc.common.view.RegisteredDialog;
import org.bidib.wizard.mvc.common.view.ViewCloseListener;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.loco.controller.LocoControlListener;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.loco.model.LocoConfigModel;
import org.bidib.wizard.mvc.loco.view.LocoDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LocoController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoController.class);
    private final CommandStationNodeInterface node;
    private final JFrame parent;
    private final LocoConfigModel locoConfigModel = new LocoConfigModel();
    private LocoDialog locoDialog;
    private LocoModelListener locoModelListener;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private LocoService locoService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ConsoleService consoleService;
    private CompositeDisposable compDispMessages;
    private final NodeProvider nodeProvider;
    private ScheduledExecutorService commandStationStatusWorker;
    private ScheduledExecutorService commandStationSpeedWorker;
    private final DialogRegistry dialogRegistry;
    private final Map<Class<? extends AbstractMessageEvent>, MessageEventConsumer<AbstractMessageEvent, NodeInterface>> messageActionMap = new HashMap();

    public LocoController(CommandStationNodeInterface node, JFrame parent, NodeProvider nodeProvider, DialogRegistry dialogRegistry) {
        this.node = node;
        this.parent = parent;
        this.nodeProvider = nodeProvider;
        this.dialogRegistry = dialogRegistry;
        this.compDispMessages = new CompositeDisposable();
    }

    public void start(AddressData initialAddress, SpeedSteps speedSteps, LocoListModel locoListModel) {
        LocoModel locoModel;
        LOGGER.info("Current connectionService: {}", (Object)this.connectionService);
        Integer searchLocoAddress = null;
        if (locoListModel != null) {
            searchLocoAddress = locoListModel.getAddress();
        } else if (initialAddress != null) {
            searchLocoAddress = initialAddress.getAddress();
        }
        if (CollectionUtils.isNotEmpty((Collection)this.dialogRegistry.getDialogRegistry())) {
            String searchKey = LocoDialog.prepareKey((Integer)searchLocoAddress);
            RegisteredDialog existingDialog = (RegisteredDialog)IterableUtils.find((Iterable)this.dialogRegistry.getDialogRegistry(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
            if (existingDialog != null) {
                LOGGER.info("Found existing dialog: {}", (Object)existingDialog);
                try {
                    if (SystemUtils.IS_OS_WINDOWS) {
                        WindowUtils.bringWindowToFront((Window)((Window)existingDialog));
                    } else {
                        ((Window)existingDialog).toFront();
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Bring the existing dialog to front failed.");
                }
                return;
            }
            LOGGER.info("No existing dialog found.");
        }
        if (ProductUtils.isRFBasisNode((long)this.node.getNode().getUniqueId()) || ProductUtils.isSpeedometer((long)this.node.getNode().getUniqueId())) {
            LOGGER.info("The default speed steps for the decoders on the RF Basis Node or Speedometer is 128.");
            this.locoConfigModel.setSpeedSteps(speedSteps != null ? speedSteps : this.settingsService.getWizardSettings().getLastSelectedSpeedSteps());
            this.locoConfigModel.setCarControlEnabled(true);
        } else {
            this.locoConfigModel.setSpeedSteps(speedSteps != null ? speedSteps : this.settingsService.getWizardSettings().getLastSelectedSpeedSteps());
        }
        if (locoListModel != null) {
            LOGGER.info("Create new locoModel with locoListModel: {}", (Object)locoListModel);
            locoModel = new LocoModel(locoListModel);
            this.locoConfigModel.setSpeedSteps(locoModel.getSpeedSteps());
        } else if (initialAddress != null) {
            LOGGER.info("Create new locoModel from the provided initial address: {}", (Object)initialAddress);
            LocoListModel llm = this.locoService.getOrCreateLoco("main", this.node, initialAddress.getAddress());
            locoModel = new LocoModel(llm);
            this.locoConfigModel.setSpeedSteps(locoModel.getSpeedSteps());
        } else {
            LOGGER.info("Create new empty locoModel with default speedSteps.");
            locoModel = new LocoModel(null);
            locoModel.setSpeedSteps(this.locoConfigModel.getSpeedSteps());
        }
        this.prepareMessageMap(locoModel);
        try {
            CompositeDisposable disp = new CompositeDisposable();
            Disposable dispConnStatus = this.connectionService.subscribeConnectionStatusChanges(connectionInfo -> {
                if (connectionInfo.getConnectionId().equals("main")) {
                    LOGGER.info("Current state: {}", (Object)connectionInfo.getConnectionState());
                    switch (5.$SwitchMap$org$bidib$api$json$types$ConnectionPhase[connectionInfo.getConnectionState().getActualPhase().ordinal()]) {
                        case 1: {
                            LOGGER.info("The connection was opened.");
                            this.registerForMessages();
                            break;
                        }
                        case 2: {
                            LOGGER.info("The connection was closed.");
                            this.compDispMessages.dispose();
                            if (this.locoDialog != null) {
                                this.locoDialog.close(this.settingsService);
                                this.locoDialog = null;
                            }
                            disp.dispose();
                            break;
                        }
                    }
                }
            }, error -> LOGGER.warn("The connection status change caused an error.", error));
            disp.add(dispConnStatus);
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as node listener failed.", (Throwable)ex);
        }
        try {
            LOGGER.info("Check if the connection is connected already.");
            boolean isConnected = this.connectionService.isConnected("main");
            if (isConnected) {
                this.registerForMessages();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Register for messages failed.", (Throwable)ex);
        }
        LOGGER.info("Create new instance of LocoDialog.");
        2 locoControlListener = new /* Unavailable Anonymous Inner Class!! */;
        this.locoDialog = new LocoDialog(this.parent, locoModel, this.locoConfigModel, this.settingsService, (LocoControlListener)locoControlListener, lm -> this.registerLocoModelListener(lm), newLocoAddress -> this.changeLocoAddress(locoModel, newLocoAddress));
        this.locoDialog.addViewCloseListener((ViewCloseListener)new /* Unavailable Anonymous Inner Class!! */);
        LOGGER.info("Register the LocoDialog in the dialog registry: {}", (Object)this.locoDialog);
        this.dialogRegistry.getDialogRegistry().add(this.locoDialog);
        try {
            if (this.node.getCommandStationStatus() == null) {
                LOGGER.info("Subscribe to command station status changes.");
                CompositeDisposable disp = new CompositeDisposable();
                Disposable dispCsState = this.node.subscribeSubjectCommandStationState(csState -> {
                    LOGGER.info("Current command station state: {}", csState);
                    if (CommandStationStatus.isOffState((CommandStationStatus)csState)) {
                        LOGGER.info("Set the command station to status GO.");
                        if (this.commandStationStatusWorker == null) {
                            this.commandStationStatusWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("commandStationStatusWorkers-thread-%d").build());
                        }
                        this.commandStationStatusWorker.submit(() -> this.commandStationService.setCommandStationState("main", this.node, CommandStationStatus.GO));
                    }
                    disp.dispose();
                }, error -> {
                    LOGGER.warn("Get the current command station state failed.");
                    disp.dispose();
                }, () -> LOGGER.warn("Get the current command station state subscription has completed, node: {}", (Object)this.node));
                disp.add(dispCsState);
                this.commandStationService.queryCommandStationState("main", this.node);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get command station state failed.", (Throwable)ex);
        }
    }

    public void registerLocoModelListener(LocoModel locoModel) {
        LOGGER.info("Register the locoModel listener for locoModel: {}", (Object)locoModel);
        if (this.commandStationSpeedWorker == null) {
            this.commandStationSpeedWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("commandStationSpeedWorkers-thread-%d").build());
        }
    }

    private void setSpeed(LocoModel locoModel, Integer speed, DirectionStatus directionStatus) {
        LOGGER.info("Set loco speed: {}, direction: {}", (Object)speed, (Object)directionStatus);
        if (locoModel.getAddress() == null) {
            LOGGER.warn("No address available.");
            return;
        }
        if (speed != null) {
            Integer locoAddress = locoModel.getAddress();
            SpeedSteps speedSteps = locoModel.getSpeedSteps();
            if (directionStatus != null) {
                locoModel.setDirection(directionStatus);
            }
            DirectionStatus direction = locoModel.getDirection();
            if (speed > 1) {
                switch (5.$SwitchMap$org$bidib$wizard$model$status$SpeedSteps[speedSteps.ordinal()]) {
                    case 1: {
                        speed = speed * 127 / 28;
                        break;
                    }
                    case 2: {
                        speed = speed * 127 / 14;
                        break;
                    }
                }
            }
            LOGGER.info("The speed has changed in the locoModel. Send the new speed value: {}, direction: {}, address: {}, speedSteps: {}", new Object[]{speed, direction, locoAddress, speedSteps});
            Integer speedValue = speed;
            this.commandStationSpeedWorker.submit(() -> {
                try {
                    DefaultContext context = new DefaultContext();
                    this.registerActiveRfBasis(locoModel, (Context)context);
                    SwingUtils.executeInEDT(() -> locoModel.incCounterCsDrive());
                    this.locoService.setSpeed("main", this.node, locoAddress.intValue(), speedSteps, speedValue, direction, null, null, (Context)context);
                }
                catch (NoAnswerException ex) {
                    LOGGER.warn("Set speed failed.", (Throwable)ex);
                    SwingUtilities.invokeLater(() -> {
                        ConsoleController.ensureConsoleVisible();
                        if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                            this.consoleService.addConsoleLine(ConsoleColor.red, ex.getMessage());
                        } else {
                            this.consoleService.addConsoleLine(ConsoleColor.red, "Set speed failed.");
                        }
                    });
                }
                catch (Exception ex) {
                    LOGGER.warn("Set speed failed.", (Throwable)ex);
                }
            });
        } else {
            LOGGER.debug("No speed value in model.");
        }
    }

    private void setSpeedSteps(LocoModel locoModel, SpeedSteps speedSteps) {
        LOGGER.info("Set the speedSteps: {}, locoModel: {}", (Object)speedSteps, (Object)locoModel);
        locoModel.setSpeedSteps(speedSteps);
    }

    private void changeLocoAddress(LocoModel locoModel, Integer locoAddress) {
        LOGGER.info("Change the locoAddress: {}", (Object)locoAddress);
        if (locoAddress != null) {
            LocoListModel locoListModel = this.locoService.getOrCreateLoco("main", this.node, locoAddress.intValue());
            locoModel.setLocoListModel(locoListModel);
        } else {
            locoModel.setLocoListModel(null);
        }
        this.locoDialog.updateDialogTitle(locoAddress);
        locoModel.setReportedCellNumber(null);
    }

    private void registerForMessages() {
        LOGGER.info("Register for messages from the connection.");
        try {
            BidibConnection connection = this.connectionService.find("main");
            Disposable dispMessages = connection.getSubjectMessages().subscribe(arg_0 -> this.handleBidibMessageEvent(arg_0));
            this.compDispMessages.add(dispMessages);
        }
        catch (ConnectionException ex) {
            LOGGER.warn("No connection found, register on messages is skipped.", (Throwable)ex);
        }
    }

    private void prepareMessageMap(LocoModel locoModel) {
        LOGGER.info("Prepare the message map.");
        this.messageActionMap.put(OccupancyDynStateMessageEvent.class, (evt, node) -> {
            OccupancyDynStateMessageEvent event = (OccupancyDynStateMessageEvent)evt;
            AddressData decoderAddress = event.getDecoderAddress();
            int dynNumber = event.getDynNumber();
            int dynValue = event.getDynValue();
            LOGGER.info("dynState, decoderAddress: {}, dynNumber: {}, dynValue: {}", new Object[]{decoderAddress, dynNumber, dynValue});
            if (locoModel.getAddress() != null && decoderAddress.getAddress() == locoModel.getAddress().intValue() && dynNumber == 3) {
                SwingUtils.executeInEDT(() -> locoModel.setDynStateEnergy(dynValue));
            } else {
                LOGGER.debug("The dynState ist not forwarded to model");
            }
        });
        this.messageActionMap.put(OccupancyCvMessageEvent.class, (evt, node) -> {
            OccupancyCvMessageEvent event = (OccupancyCvMessageEvent)evt;
            LOGGER.info("Received new occupancy CV event: {}", (Object)event);
            LOGGER.warn("The occupancy CV event is not processed and discarded: {}", (Object)event);
        });
        this.messageActionMap.put(OccupancyPositionMessageEvent.class, (evt, node) -> {
            OccupancyPositionMessageEvent event = (OccupancyPositionMessageEvent)evt;
            LOGGER.debug("Process the event: {}", (Object)event);
            if (event.getLocationType() == PositionLocationEnum.CELL_IDENTIFIER && locoModel.getAddress() != null && event.getDecoderAddress() == locoModel.getAddress()) {
                SwingUtilities.invokeLater(() -> {
                    LOGGER.info("Update the cellIdentifier: {}", (Object)event);
                    locoModel.setReportedCellNumber(Integer.valueOf(event.getLocationAddress()));
                });
            } else {
                LOGGER.debug("Do not show position feedback with type: {}", (Object)event.getLocationType());
            }
        });
    }

    private void handleBidibMessageEvent(AbstractMessageEvent event) {
        LOGGER.debug("Handle the message event: {}", (Object)event);
        try {
            MessageEventConsumer action = (MessageEventConsumer)this.messageActionMap.get(event.getClass());
            if (action != null) {
                action.accept((Object)event, (Object)this.node.getNode());
            } else {
                LOGGER.debug("No message event action configured for event: {}", (Object)event);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Execute the message event action failed, node: {}, event: {}", new Object[]{this.node, event, ex});
        }
    }

    private void unregisterView(RegisteredDialog view) {
        block5: {
            if (view != null) {
                try {
                    if (!CollectionUtils.isNotEmpty((Collection)this.dialogRegistry.getDialogRegistry())) break block5;
                    String searchKey = view.getKey();
                    RegisteredDialog existingDialog = (RegisteredDialog)IterableUtils.find((Iterable)this.dialogRegistry.getDialogRegistry(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                    if (existingDialog != null) {
                        LOGGER.info("Found existing dialog to unregister: {}", (Object)existingDialog);
                        this.dialogRegistry.getDialogRegistry().remove(existingDialog);
                        LOGGER.info("Registry after remove: {}", (Object)this.dialogRegistry);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Unregister view failed: {}", (Object)view, (Object)ex);
                }
            } else {
                LOGGER.info("No view available to unregister.");
            }
        }
    }

    private void registerActiveRfBasis(LocoModel locoModel, Context context) {
        if (this.locoConfigModel.isCarControlEnabled() && locoModel.getActiveBase() != null && locoModel.getActiveBase() != RfBasisMode.SINGLE) {
            RfBasisMode activeRfBase = locoModel.getActiveBase();
            this.registerRfBasisInContext(context, activeRfBase);
        }
    }

    private void registerPrevActiveRfBasis(LocoModel locoModel, Context context) {
        if (this.locoConfigModel.isCarControlEnabled() && locoModel.getPrevActiveBase() != null && locoModel.getPrevActiveBase() != RfBasisMode.SINGLE) {
            RfBasisMode prevActiveRfBase = locoModel.getPrevActiveBase();
            this.registerRfBasisInContext(context, prevActiveRfBase);
        }
    }

    private void registerRfBasisInContext(Context context, RfBasisMode rfBase) {
        context.unregister("activeRfBasis");
        if (rfBase.getBaseNumber() != null) {
            int activeBaseNumber = rfBase.getBaseNumber();
            NodeInterface rfBasisNode = this.nodeProvider.getNodes().stream().filter(bidibNode -> ProductUtils.isRFBasisNode((long)bidibNode.getUniqueId()) && bidibNode.getBaseNumber() == activeBaseNumber).findFirst().orElse(null);
            if (rfBasisNode != null) {
                LOGGER.info("Found the active rfBasisNode: {}", (Object)rfBasisNode);
                context.register("activeRfBasis", (Object)rfBasisNode.getNode());
            } else {
                LOGGER.warn("No active rfBasisNode found for activeBaseNumber: {}", (Object)activeBaseNumber);
            }
        } else {
            LOGGER.info("No base number for active rf base available.");
        }
    }
}

