/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.mvc.common.view.table.CustomBooleanCellEditor;
import org.bidib.wizard.mvc.common.view.table.CustomBooleanCellRenderer;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.bidib.wizard.mvc.locolist.view.JSparklinesBarChartTableCellRenderer;
import org.bidib.wizard.mvc.locolist.view.LocoLightRenderer;
import org.bidib.wizard.mvc.locolist.view.LocoListBeanModel;
import org.bidib.wizard.mvc.locolist.view.LocoListMenu;
import org.bidib.wizard.mvc.locolist.view.LocoTableTableModel;
import org.bidib.wizard.mvc.locolist.view.LocoTableView;
import org.bidib.wizard.mvc.locolist.view.MultiCheckWithLightRenderer;
import org.jfree.chart.plot.PlotOrientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoTableView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoTableView.class);
    private final DockKey DOCKKEY = new DockKey("LocoTableView");
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:150dlu:grow";
    private final JButton queryLocoListButton = new JButton(Resources.getString(this.getClass(), (String)"queryLocoList"));
    private final JComponent contentPanel;
    private final LocoListBeanModel locoListBeanModel;
    private final JTextField locoAddress;
    private InputValidationDocument addressDocument;
    private ValueModel addressValueModel;
    private final SelectionInList<LocoListModel> locoSelection;
    private final LocoTableControllerListener locoTableController;

    public LocoTableView(LocoTableControllerListener locoTableController, LocoTableModel locoTableModel) {
        this.locoTableController = locoTableController;
        this.locoListBeanModel = new LocoListBeanModel();
        this.DOCKKEY.setName(Resources.getString(this.getClass(), (String)"title"));
        this.DOCKKEY.setFloatEnabled(true);
        this.DOCKKEY.setAutoHideEnabled(false);
        LOGGER.info("Create new LocoTableView");
        this.locoSelection = new SelectionInList((ListModel)locoTableModel.getLocoListModel());
        LocoTableTableModel tableModel = new LocoTableTableModel(this.locoSelection);
        1 locoTable = new /* Unavailable Anonymous Inner Class!! */;
        locoTable.adjustRowHeight();
        locoTable.setSelectionModel((ListSelectionModel)new SingleListSelectionAdapter(this.locoSelection.getSelectionIndexHolder()));
        TableColumnModel tcm = locoTable.getColumnModel();
        tcm.getColumn(3).setCellEditor((TableCellEditor)new CustomBooleanCellEditor("/icons/locolist/arrow_right.png", "/icons/locolist/arrow_left.png"));
        tcm.getColumn(3).setCellRenderer((TableCellRenderer)new CustomBooleanCellRenderer("/icons/locolist/arrow_right.png", "/icons/locolist/arrow_left.png"));
        JSparklinesBarChartTableCellRenderer renderer = new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(-127.0), Double.valueOf(127.0), new Color(51, 153, 255).darker(), Color.GREEN.darker());
        renderer.showAbsValue(true);
        renderer.showNumberAndChart(true, 40);
        tcm.getColumn(2).setCellRenderer((TableCellRenderer)renderer);
        TableColumn tc = tcm.getColumn(0);
        tc.setMinWidth(50);
        tc.setMaxWidth(60);
        tc.setPreferredWidth(60);
        tc = tcm.getColumn(2);
        tc.setMinWidth(100);
        tc.setPreferredWidth(150);
        tc = tcm.getColumn(3);
        tc.setMinWidth(50);
        tc.setMaxWidth(60);
        tc.setPreferredWidth(60);
        tc = tcm.getColumn(4);
        tc.setMinWidth(70);
        tc.setMaxWidth(70);
        tc.setPreferredWidth(70);
        LocoLightRenderer locoLightRenderer = new LocoLightRenderer(16);
        tcm.getColumn(5).setCellRenderer((TableCellRenderer)locoLightRenderer);
        tc = tcm.getColumn(5);
        tc.setMinWidth(40);
        tc.setMaxWidth(60);
        tc.setPreferredWidth(40);
        MultiCheckWithLightRenderer multiCheckRenderer = new MultiCheckWithLightRenderer(15);
        tc = tcm.getColumn(6);
        tc.setCellRenderer((TableCellRenderer)multiCheckRenderer);
        tc.setPreferredWidth(90);
        MultiCheckWithLightRenderer multiCheckRendererFull = new MultiCheckWithLightRenderer(255);
        tc = tcm.getColumn(7);
        tc.setCellRenderer((TableCellRenderer)multiCheckRendererFull);
        tc.setPreferredWidth(160);
        tc = tcm.getColumn(8);
        tc.setCellRenderer((TableCellRenderer)multiCheckRendererFull);
        tc.setPreferredWidth(160);
        tc = tcm.getColumn(9);
        tc.setCellRenderer((TableCellRenderer)multiCheckRendererFull);
        tc.setPreferredWidth(160);
        SortableTableModel sortableTableModel = (SortableTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)locoTable.getModel(), SortableTableModel.class);
        sortableTableModel.setColumnSortable(0, true);
        sortableTableModel.sortColumn(0, true, true);
        boolean debugDialog = false;
        FormBuilder dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows("p, 3dlu, fill:pref:grow", new Object[0]).panel((JPanel)(debugDialog ? new FormDebugPanel() : new JPanel(new BorderLayout())));
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.queryLocoListButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        PropertyAdapter queryLocoListButtonEnabled = new PropertyAdapter((Object)locoTableModel, "csNodeSelected", true);
        PropertyConnector.connect((Object)queryLocoListButtonEnabled, (String)"value", (Object)this.queryLocoListButton, (String)"enabled");
        SelectionInList csQueryTypeSelection = new SelectionInList((Object[])CsQueryTypeEnum.values());
        PropertyAdapter csQueryTypeModel = new PropertyAdapter((Object)this.locoListBeanModel, "csQueryType", true);
        ComboBoxAdapter comboBoxAdapterCsQueryType = new ComboBoxAdapter((ListModel)csQueryTypeSelection, (ValueModel)csQueryTypeModel);
        JComboBox comboCsQueryType = new JComboBox();
        comboCsQueryType.setModel(comboBoxAdapterCsQueryType);
        comboCsQueryType.setRenderer(new CsQueryTypeCellRenderer(this));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"csQueryType"), new Object[0]).xy(1, 1);
        dialogBuilder.add(comboCsQueryType).xy(3, 1);
        JPanel locoListActionButtons = new ButtonBarBuilder().addButton((JComponent)this.queryLocoListButton).build();
        dialogBuilder.add((Component)locoListActionButtons).xy(5, 1);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"address"), new Object[0]).xy(7, 1);
        this.addressValueModel = new PropertyAdapter((Object)this.locoListBeanModel, "address", true);
        ConverterValueModel addressConverterModel = new ConverterValueModel(this.addressValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.locoAddress = new JTextField();
        this.addressDocument = new InputValidationDocument(5, "0123456789");
        this.locoAddress.setDocument((Document)this.addressDocument);
        this.locoAddress.setColumns(5);
        Bindings.bind((JTextField)this.locoAddress, (ValueModel)addressConverterModel, (boolean)false);
        dialogBuilder.add((Component)this.locoAddress).xy(9, 1);
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)locoTable));
        locoTable.getModel().addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + locoTable.getEmptyTableText() + ":f:gray}")));
        overlayTable.setOverlayVisible(locoTable.getModel().getRowCount() == 0);
        dialogBuilder.add((Component)overlayTable).xyw(1, 3, 11);
        JPanel contentPanelTemp = dialogBuilder.build();
        this.contentPanel = contentPanelTemp;
        LocoListMenu locoTableMenu = new LocoListMenu((Component)this.contentPanel, locoTableController, (AbstractEmptyTable)locoTable, tableModel, locoTableModel);
        4 installer = new /* Unavailable Anonymous Inner Class!! */;
        locoTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    public void setDockTabName(NodeInterface node) {
        if (node != null) {
            this.DOCKKEY.setName(Resources.getString(this.getClass(), (String)"title") + " - " + this.prepareNodeLabel(node));
        } else {
            this.DOCKKEY.setName(Resources.getString(this.getClass(), (String)"title"));
        }
    }

    private LocoListModel getSelectedRow(AbstractEmptyTable locoTable, SortableTableModel sortableTableModel, LocoTableTableModel locoTableTableModel) {
        int selectedRow = locoTable.getSelectedRow();
        if ((selectedRow = sortableTableModel.getActualRowAt(selectedRow)) > -1) {
            LocoListModel locoModel = (LocoListModel)locoTableTableModel.getListModel().getElementAt(selectedRow);
            return locoModel;
        }
        return null;
    }

    private void fireOpenLocoDialog(LocoListModel locoModel) {
        this.locoTableController.openLocoDialog(locoModel);
    }

    private String prepareNodeLabel(NodeInterface node) {
        String productString;
        String nodeLabel = node.getLabel();
        if (StringUtils.isBlank((CharSequence)nodeLabel) && StringUtils.isNotBlank((CharSequence)(productString = node.getNode().getStoredString(0)))) {
            nodeLabel = productString;
        }
        return nodeLabel;
    }

    private void fireQueryLocoList() {
        if (this.locoTableController != null) {
            Integer address = this.locoListBeanModel.getAddress();
            CsQueryTypeEnum csQueryType = this.locoListBeanModel.getCsQueryType();
            LOGGER.info("Current selected csQueryType: {}, address: {}", (Object)csQueryType, (Object)address);
            this.locoTableController.queryCommandStationList(csQueryType, address);
        }
    }
}

