/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import com.jgoodies.common.base.Objects;
import hu.akarnokd.rxjava3.operators.FlowableTransformers;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.processors.PublishProcessor;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.client.common.model.ServoPortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.common.WaitCommand;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.common.script.switching.ServoPortCommand;
import org.bidib.wizard.common.script.switching.ServoPortStatusCommand;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.ports.event.PortEvent;
import org.bidib.wizard.model.ports.event.PortValueEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.ServoPortStatus;
import org.bidib.wizard.mvc.main.controller.wrapper.NodePortWrapper;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.ServoPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServoPortPanelController
implements PortScripting {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServoPortPanelController.class);
    private final MainModel mainModel;
    private final Map<NodeInterface, NodePortWrapper> testToggleRegistry = new HashMap();
    private ServoPortListPanel servoPortListPanel;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private ConsoleService consoleService;
    @Autowired
    private SettingsService settingsService;
    private final Subject<PortConfigChangeEvent> portConfigChangeEventSubject;
    private CompositeDisposable compDisp;
    private final AtomicBoolean adjustPositionInProgress = new AtomicBoolean(false);
    private final PublishProcessor<Boolean> valveSource = PublishProcessor.create();

    public ServoPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.compDisp = new CompositeDisposable();
        this.portConfigChangeEventSubject = PublishSubject.create().toSerialized();
    }

    public ServoPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        ServoPortTableModel tableModel = new ServoPortTableModel();
        tableModel.setPortListener((PortModelListener)new /* Unavailable Anonymous Inner Class!! */);
        ServoPortListPanel servoPortListPanel = new ServoPortListPanel(this, tableModel, this.mainModel, this.settingsService, tabVisibilityListener, this.portConfigChangeEventSubject);
        servoPortListPanel.setPortListener((PortListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
        this.servoPortListPanel = servoPortListPanel;
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null) {
            this.addServoPortModelListener(selectedNode);
        }
        return this.servoPortListPanel;
    }

    public void sendPortStatusAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int portNum, BidibStatus portStatus) {
        LOGGER.info("Set the port status, portNum: {}, portStatus: {}", (Object)portNum, (Object)portStatus);
        try {
            SwitchingNodeInterface selectedNode = node != null ? node : this.mainModel.getSelectedNode().getSwitchingNode();
            ServoPortStatus servoPortStatus = (ServoPortStatus)portStatus;
            ServoPort servoPort = (ServoPort)PortListUtils.findPortByPortNumber((List)selectedNode.getNode().getServoPorts(), (int)portNum);
            servoPort.setStatus((BidibStatus)servoPortStatus);
        }
        catch (Exception ex) {
            LOGGER.warn("Set servo port status failed.", (Throwable)ex);
        }
    }

    public void sendPortValueAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, int portValue) {
        LOGGER.info("Set the position on port: {}, portValue: {}", (Object)port, (Object)portValue);
        SwitchingNodeInterface selectedNode = node != null ? node : this.mainModel.getSelectedNode().getSwitchingNode();
        ServoPort servoPort = (ServoPort)PortListUtils.findPortByPortNumber((List)selectedNode.getNode().getServoPorts(), (int)port);
        if (portValue >= 0 && portValue <= 255) {
            try {
                ServoPort tempServoPort = new ServoPort();
                tempServoPort.setId(servoPort.getId());
                tempServoPort.setValue(Integer.valueOf(portValue));
                this.switchingNodeService.setPortStatus("main", selectedNode, (Port)tempServoPort);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the position on port failed.", (Throwable)ex);
            }
        } else {
            LOGGER.warn("The portValue is not in allowed range: {}", (Object)portValue);
        }
    }

    public void addTestToggleTask(NodeInterface node, ServoPort port) {
        LOGGER.info("Add test toggle task for node: {}, port: {}", (Object)node, (Object)port);
        NodePortWrapper nodePortWrapper = (NodePortWrapper)this.testToggleRegistry.remove(node);
        ScriptEngine scriptEngine = null;
        if (nodePortWrapper != null) {
            scriptEngine = nodePortWrapper.removePort((Port)port);
        }
        if (scriptEngine != null) {
            LOGGER.info("Found a node scripting engine in the registry: {}", (Object)scriptEngine);
            try {
                scriptEngine.stopScript(Long.valueOf(2000L));
            }
            catch (Exception ex) {
                LOGGER.warn("Stop script failed.", (Throwable)ex);
            }
        }
        DefaultScriptContext context = new DefaultScriptContext();
        context.register("selectedNode", (Object)node);
        context.register("mainModel", (Object)this.mainModel);
        scriptEngine = new ScriptEngine((Scripting)this, (ApplicationContext)context);
        int startPosition = 0;
        int endPosition = 255;
        ArrayList<Object> scriptCommands = new ArrayList<Object>();
        ServoPortCommand spc = new ServoPortCommand(this.consoleService);
        spc.parse("servo " + port.getId() + " " + startPosition);
        scriptCommands.add(spc);
        WaitCommand wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        for (int pos = startPosition + 1; pos < endPosition; ++pos) {
            spc = new ServoPortCommand(this.consoleService);
            spc.parse("servo " + port.getId() + " " + pos);
            scriptCommands.add(spc);
            wc = new WaitCommand(this.consoleService);
            wc.parse("wait 1000");
            scriptCommands.add(wc);
        }
        spc.parse("servo " + port.getId() + " " + endPosition);
        scriptCommands.add(spc);
        wc = new WaitCommand(this.consoleService);
        wc.parse("wait 500");
        scriptCommands.add(wc);
        ServoPortStatusCommand spsc = new ServoPortStatusCommand(this.consoleService);
        spsc.parse("servostatus " + port.getId() + " start");
        scriptCommands.add(spc);
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        scriptEngine.setScriptCommands(scriptCommands);
        if (nodePortWrapper == null) {
            LOGGER.info("Create new NodePortWrapper for node: {}", (Object)node);
            nodePortWrapper = new NodePortWrapper(node);
        }
        LOGGER.info("Put script engine in registry for node: {}", (Object)node);
        nodePortWrapper.addPort((Port)port, scriptEngine);
        this.testToggleRegistry.put(node, nodePortWrapper);
        scriptEngine.startScript();
    }

    public void stopTestToggleTask(NodeInterface node, ServoPort port) {
        LOGGER.info("Stop test toggle task for node: {}, port: {}", (Object)node, (Object)port);
        NodePortWrapper nodePortWrapper = (NodePortWrapper)this.testToggleRegistry.get(node);
        if (nodePortWrapper != null) {
            HashSet<ServoPort> toRemove = new HashSet<ServoPort>();
            if (port != null) {
                toRemove.add(port);
            } else {
                toRemove.addAll(nodePortWrapper.getKeySet());
            }
            for (Port port2 : toRemove) {
                ScriptEngine engine = nodePortWrapper.removePort(port2);
                if (engine != null) {
                    LOGGER.info("Found a node scripting engine in the registry: {}", (Object)engine);
                    try {
                        engine.stopScript(Long.valueOf(2000L));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Stop script failed.", (Throwable)ex);
                    }
                    continue;
                }
                LOGGER.warn("No scripting engine found for node: {}", (Object)node);
            }
            if (nodePortWrapper.isEmpty()) {
                LOGGER.info("No more ports registered for node: {}", (Object)node);
                this.testToggleRegistry.remove(node);
            }
        }
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save servo labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.servoPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.servoPortListPanel.refreshView());
        }
    }

    private void addServoPortModelListener(NodeInterface selectedNode) {
        LOGGER.info("Add servo port model listener for node: {}", (Object)selectedNode);
        Disposable disp = this.portConfigChangeEventSubject.toFlowable(BackpressureStrategy.BUFFER).compose(FlowableTransformers.valve((Publisher)this.valveSource)).subscribe(evt -> {
            LOGGER.info("Received event: {}", evt);
            PortTypeAware port = evt.getPort();
            try {
                ServoPort servoPort = new ServoPort();
                servoPort.setId(port.getPortNumber().intValue());
                LOGGER.info("Prepared servo port: {}", (Object)servoPort);
                this.switchingNodeService.setPortConfig("main", selectedNode.getSwitchingNode(), (Port)servoPort, null, evt.getPortConfig());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the servoport config failed.", (Throwable)ex);
                selectedNode.setNodeHasError(true);
                selectedNode.setReasonData("Set the servoport config failed.");
            }
            boolean sendPositionUpdate = false;
            if (evt.getPortConfig().size() > 0) {
                if (evt.getPortConfig().get((byte)7) != null) {
                    sendPositionUpdate = true;
                    LOGGER.info("The servo adj_l was changed.");
                } else if (evt.getPortConfig().get((byte)8) != null) {
                    sendPositionUpdate = true;
                    LOGGER.info("The servo adj_h was changed.");
                } else if (evt.getPortConfig().get((byte)9) != null) {
                    LOGGER.info("The servo speed was changed.");
                } else if (evt.getPortConfig().get((byte)10) != null) {
                    LOGGER.info("The servo extra was changed.");
                }
            }
            if (sendPositionUpdate && evt.getPortValue() != null) {
                try {
                    ServoPort servoPort = new ServoPort();
                    servoPort.setId(port.getPortNumber().intValue());
                    int currentPortValue = evt.getPortValue();
                    servoPort.setValue(Integer.valueOf(currentPortValue < 255 ? currentPortValue + 1 : currentPortValue - 1));
                    LOGGER.info(">>> New requested port value: {}, current value for adjustment: {}", (Object)currentPortValue, (Object)servoPort.getValue());
                    LOGGER.info(">>> Block the valve.");
                    this.adjustPositionInProgress.set(true);
                    this.valveSource.onNext((Object)false);
                    CompositeDisposable compDispSubscribePortEvents = new CompositeDisposable();
                    Disposable dispSubscribePortEvents = this.switchingNodeService.subscribePortEvents("main", pe -> {
                        PortValueEvent pve;
                        LOGGER.info("Received a port event: {}", pe);
                        if (pe instanceof PortValueEvent && (pve = (PortValueEvent)pe).getPort().equals((Object)servoPort)) {
                            LOGGER.info(">>> The value of the selected port has changed, signalled value: {}, target servo port value: {}", (Object)pve.getPortValue(), (Object)currentPortValue);
                            if (Objects.equals((Object)currentPortValue, (Object)pve.getPortValue())) {
                                LOGGER.info(">>> Dispose the subscription after receive the final port value.");
                                compDispSubscribePortEvents.dispose();
                                this.compDisp.delete((Disposable)compDispSubscribePortEvents);
                                this.adjustPositionInProgress.set(false);
                                LOGGER.info(">>> Enable the valve.");
                                this.valveSource.onNext((Object)true);
                            } else {
                                servoPort.setValue(Integer.valueOf(currentPortValue));
                                LOGGER.info(">>> Send current port value: {}", (Object)currentPortValue);
                                this.switchingNodeService.setPortStatus("main", selectedNode.getSwitchingNode(), (Port)servoPort);
                                LOGGER.info("Sent the final value for port: {}, port.value: {}", (Object)port, (Object)servoPort.getValue());
                                LOGGER.info(">>> Enable the valve.");
                                this.valveSource.onNext((Object)true);
                            }
                        }
                    }, th -> {
                        LOGGER.warn("The port event subject has signalled an error.", th);
                        compDispSubscribePortEvents.dispose();
                        this.compDisp.delete((Disposable)compDispSubscribePortEvents);
                        LOGGER.info(">>> Enable the valve.");
                        this.adjustPositionInProgress.set(false);
                        this.valveSource.onNext((Object)true);
                    }, () -> {
                        LOGGER.info("The port event subject has completed!");
                        compDispSubscribePortEvents.dispose();
                        this.compDisp.delete((Disposable)compDispSubscribePortEvents);
                        LOGGER.info(">>> Enable the valve.");
                        this.adjustPositionInProgress.set(false);
                        this.valveSource.onNext((Object)true);
                    }, portEvent -> ServoPortPanelController.filterPortValueEvents((PortEvent)portEvent, (ServoPort)servoPort));
                    this.compDisp.add(dispSubscribePortEvents);
                    compDispSubscribePortEvents.add(dispSubscribePortEvents);
                    this.switchingNodeService.setPortStatus("main", selectedNode.getSwitchingNode(), (Port)servoPort);
                    LOGGER.info("Test pressed for port: {}, port.value: {}", (Object)port, (Object)servoPort.getValue());
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the servoport status failed.", (Throwable)ex);
                    selectedNode.setNodeHasError(true);
                    selectedNode.setReasonData("Set the servoport status failed.");
                }
            }
        });
        this.compDisp.add(disp);
    }

    private static boolean filterPortValueEvents(PortEvent event, ServoPort servoPort) {
        if (event instanceof PortValueEvent) {
            PortValueEvent pve = (PortValueEvent)event;
            return pve.getPort().equals((Object)servoPort);
        }
        return false;
    }
}

